<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Artisan;
use DB;

class ExecuteJobs extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'execute:jobs';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Execute Jobs';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        // Check if there are any jobs to process
        $job_count = DB::table('jobs')->count();
        
        if($job_count === 0) {
            $this->info('No jobs to process.');
            return;
        }
        
        $this->info("Processing {$job_count} jobs...");
        
        // Process jobs in batches for better performance
        $processed = 0;
        $max_attempts = min($job_count, 50); // Limit to prevent infinite loops
        
        for($i = 0; $i < $max_attempts; $i++) {
            try {
                $result = Artisan::call('queue:work', ['--once' => true, '--timeout' => 60]);
                
                if($result === 0) {
                    $processed++;
                } else {
                    // No more jobs to process
                    break;
                }
            } catch(\Exception $e) {
                \Log::error('command-execute:jobs: '.$e->getMessage());
                break;
            }
        }
        
        $this->info("Processed {$processed} jobs.");
    }
}
