<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\DripSchedule;
use App\Models\DripScheduleStatLog;
use App\Models\SendingServer;
use App\Models\Drip;
use App\Http\Helper\Helper;
use App\Services\ElasticEmailService;
use App\Services\SendGridService;
use App\Services\RssFeedService;
use DB;


class RunDripsCampaigns extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'run:drips-campaigns';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Process the drip campaigns that have been scheduleds via triggers';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        // Only need to fetch one drip other cron will entertain next drip if exist
        $drip_schedules = DripSchedule::whereInProgress(false)
          ->whereStatus('Running')
          ->get();
        foreach($drip_schedules as $drip_schedule) {
          if(!empty($drip_schedule)) {
            // Next cron will not enterin this drip schedulep until finish
            DripSchedule::whereId($drip_schedule->id)->update(['in_progress' => true]);

            $trigger = \App\Models\Trigger::whereId($drip_schedule->trigger_id)->first();

            $lists = \App\Models\Lists::whereIn('id', explode(',', $drip_schedule->list_ids))->get();

            // mail headers will be set for admin 
            $mail_headers = json_decode(DB::table('users')->select('mail_headers')->whereAppId($trigger->app_id)->whereParentId(0)->value('mail_headers'), true);


            foreach($lists as $list) {
              $contact_result = \App\Models\Contact::whereListId($list->id)
                ->whereIsActive(true)
                ->whereIsUnsubscribed(false);

              if($drip_schedule->send_to_existing == 'No') {
                $contact_result->where('created_at', '>', $drip_schedule->created_at);
              }


                $contact_result->chunk(1000, function($contacts) use ($drip_schedule, $list, $trigger, $mail_headers) {

                  $drips = Drip::whereGroupId($drip_schedule->drip_group_id)
                    ->whereIsActive(true)
                    ->orderBy('after_minutes', 'ASC')
                    ->get();

                  // Get schedle drip stat
                  $drip_schedule_stat = \App\Models\DripScheduleStat::whereDripScheduleId($drip_schedule->id)->first();

                  // settings
                  $settings = DB::table('settings')->whereId(config('custom.app_id'))->first();
                  $tracking = $settings->tracking == 'enabled' ? true : false;
                  $app_url = $settings->app_url;


                  $sending_speed = json_decode($trigger->attributes)->sending_speed;
                  if(!empty($sending_speed) && $sending_speed == 'limited') {
                    $sending_limit = json_decode($trigger->attributes)->sending_limit;
                    $wait = floor(3600 / $sending_limit); // divide on 1 hour
                  } else {
                    $wait = false;
                  }
                  // Pick sending server id
                  $sending_server_ids = json_decode($trigger->sending_server_ids);
                  // Retrun array of sending servers
                  $sending_servers = SendingServer::getActiveSeningServers($sending_server_ids, 'array');

                  // If no sending server then no need to do anything
                  if(empty($sending_servers)) {
                    $this->setScheduleStatus($schedule->id, 'System Paused');
                  }

                  // Will be use to reset the sending_server array when  all picked
                  $sending_servers_data = $sending_servers;

                  $carbon = new \Carbon\Carbon();
                  foreach($contacts as $contact) {
                    foreach($drips as $drip) {

                      // Check if drip is paused
                      $drip_status = DripSchedule::whereId($drip_schedule->id)->value('status');
                      if($drip_status == 'Paused') exit;

                      // If already sent a drip on a contact
                      if(DripScheduleStatLog::whereDripId($drip->id)->whereDripScheduleStatId($drip_schedule->id)->whereEmail($contact->email)->exists()) continue;

                      // If bounced
                      if(DB::table('global_bounces')->whereEmail($contact->email)->exists()) continue;

                      // Get drip time
                      $drip_stat_log_contact = DripScheduleStatLog::select('created_at')->whereDripScheduleStatId($drip_schedule->id)->whereEmail($contact->email)->orderBy('id', 'Desc')->first();
                      if(!empty($drip_stat_log_contact)) {
                        $drip_time = $carbon->parse($drip_stat_log_contact->created_at)->addMinutes($drip->after_minutes);
                      } else {
                        $drip_time = $carbon->parse($contact->created_at)->addMinutes($drip->after_minutes);
                      }
                      

                      // Send email
                      if($drip_time <= \Carbon\Carbon::now()) {

                        // Sending servers info that assigned previously to reset the sending servers when all picked
                        if(empty($sending_servers)) {
                          $sending_servers = $sending_servers_data;
                          
                        }

                        $sending_server = array_shift($sending_servers);

                        $connection = Helper::configureSendingNode($sending_server['type'], $sending_server['sending_attributes']);
                        if($connection['success']) {
                          $sending_domain = Helper::getSendingDomainFromEmail($sending_server['from_email']);
                          // if no domain found
                          try {
                            $domain = $sending_domain->protocol.$sending_domain->domain;
                          } catch(\Exception $e) {
                            continue;
                          }
                          $message_id = Helper::getCustomMessageID($domain);

                          if(!empty($sending_server['tracking_domain'])) {
                            $tracking_domain = $sending_server['tracking_domain'];
                          } else {
                            $tracking_domain = Helper::getAppURL();
                          }


                        // render RSS Feed
                        $content = (new RssFeedService())->parseAndRender($drip->content);

                        // Replace spintags
                        $content = Helper::replaceSpintags(Helper::decodeString($content));
                        $email_subject = Helper::replaceSpintags(Helper::decodeString($drip->email_subject));

                        // Replace custom field
                        $content = Helper::replaceCustomFields($content, $contact->customFields);
                        $email_subject = Helper::replaceCustomFields($email_subject, $contact->customFields);

                        // Replace Spintax [Random: hi|hello|hey]
                        $content = Helper::spinTaxParser($content);
                        $email_subject = Helper::spinTaxParser($email_subject);

                        // Default Parser
                        $content = Helper::defaultValueParser($content);
                        $email_subject = Helper::defaultValueParser($email_subject);

                        if($trigger->from_detail == 'custom') {
                          $from_detail_custom = json_decode($trigger->from_detail_custom);
                          $from_name = $from_detail_custom->from_name;
                          $from_email = $from_detail_custom->from_email;
                          $reply_email = $from_detail_custom->reply_email;
                        } elseif($trigger->from_detail == 'list') {
                          $from_name = $contact->list->from_name;
                          $from_email = $contact->list->from_email;
                          $reply_email = $contact->list->reply_email;
                        } else {
                          $from_name = $sending_server['from_name'];
                          $from_email = $sending_server['from_email'];
                          $reply_email = $sending_server['reply_email'];
                        }

                          

                          // Create DripScheduleStatLog and the id would be use to track the email
                          $drip_schedule_stat_log_data = [
                            'drip_schedule_stat_id' => $drip_schedule_stat->id,
                            'drip_id' => $drip->id,
                            'drip_name' => $drip->name,
                            'message_id' => $message_id,
                            'email' => $contact->email,
                            'list' => $list->name,
                            'broadcast' => $email_subject,
                            'sending_server' => $sending_server['name'],
                          ];

                          $drip_schedule_stat_log = DripScheduleStatLog::create($drip_schedule_stat_log_data);

                          // Data that will be use to replce the system variables
                          $data_values = [
                            'sender-name'    => $from_name,
                            'sender-email'   => $from_email,
                            'domain'         => $tracking_domain,
                            'message-id'     => $message_id,
                            'campaign-id'    => base64_encode($drip_schedule_stat_log->id),
                            'type'           => 'd'
                          ];

                          // Replace system variables
                          $email_subject = Helper::replaceSystemVariables($contact, $email_subject, $data_values);
                          $content = Helper::replaceSystemVariables($contact, $content, $data_values);

                          // for to get replies info
                          $content .= "<span id='rz-ref-drip-{$drip_schedule_stat_log->id}-{$drip->app_id}-rz-ref'></span>";

                          if($tracking) {
                            // click tracking should be before track_opens becuase don't want to convert that url
                            $content = Helper::convertLinksForClickTracking($drip_schedule_stat_log->id, $tracking_domain, $content, $app_url, '/d/click/');

                            // Make open tracking url and pixel d=drip
                            $track_open = $tracking_domain.'/d/open/'.base64_encode($drip_schedule_stat_log->id);
                            $content .= "<div style='float:left; clear:both; font-family:Arial; margin:40px auto; width:100%; line-height:175%; font-size:11px; color:#434343'><img border='0' src='".$track_open."' width='1' height='1' alt=''></div>";
                          }

                          // Will be check either need to load sending servers again or not
                          $load_sending_servers = false;
                          
                          // If sending type that supported by framework will be send with a same way
                          if(in_array($sending_server['type'], Helper::sendingServersFramworkSuported())) {
                                $message = new \Symfony\Component\Mime\Email();
                                $message->from(new \Symfony\Component\Mime\Address($from_email, "$from_name"));
                                $message->to($contact->email);
                                $message->subject($email_subject);
                                !empty($reply_email) ? $message->replyTo($reply_email) : '';
                                if(!empty($sending_server['bounce']['email'])) {
                                  $message->returnPath($sending_server['bounce']['email']);
                                }

                                // adding the envelope becuase bounce email having issue
                                $envelope = new \Symfony\Component\Mailer\Envelope(
                                    new \Symfony\Component\Mime\Address($from_email, "$from_name"), // From email
                                    [new \Symfony\Component\Mime\Address($contact->email)] // Envelope recipient(s)
                                );

                                $headers= $message->getHeaders();
                                $headers->addIdHeader('Message-ID', $message_id);
                                // Header will use to process the bounces and fbls etc.
                                $headers->addTextHeader('RZ-Type-ID', "drip-{$drip_schedule_stat_log->id}-{$drip->app_id}");
                                // Required header for good inboxing - use proper unsubscribe URL
                                $unsub_url = $tracking_domain . '/contact/do-unsub/' . base64_encode($contact->id) . "/{$drip_schedule_stat_log->id}/{$data_values['type']}";
                                $headers->addTextHeader('List-Unsubscribe', "<{$unsub_url}>");
                                $headers->addTextHeader('List-Unsubscribe-Post', 'List-Unsubscribe=One-Click');

                                // Header will be use to process reports for Amazon
                                if($sending_server['type'] == 'amazon_ses_api' && !empty(json_decode($sending_server['sending_attributes'])->process_reports) && json_decode($sending_server['sending_attributes'])->process_reports == 'yes') {
                                  if(!empty(json_decode($sending_server['sending_attributes'])->amazon_configuration_set)) {
                                    $headers->addTextHeader('X-SES-CONFIGURATION-SET', json_decode($sending_server['sending_attributes'])->amazon_configuration_set);
                                  }
                                }

                                if(!empty($mail_headers)) {
                                  foreach($mail_headers as $header_key => $header_value) {
                                    $header_value = Helper::replaceSpintags($header_value);
                                    $header_value = Helper::replaceCustomFields($header_value, $contact->customFields);
                                    $header_value = Helper::replaceSystemVariables($contact, $header_value, $data_values);
                                    $header_value = Helper::spinTaxParser($header_value);

                                    $header_key = Helper::replaceHyphen($header_key);

                                    $message->getHeaders()->addTextHeader($header_key, $header_value);
                                  }
                                }

                                $message->html($content);
                                $message->text(htmlspecialchars_decode(strip_tags($content)));

                                try {
                                  $connection['transport']->send($message);
                                  $status = 'Sent';
                                } catch(\Exception $e) {
                                  \Log::error('run:drips-campaigns => '.$e->getMessage());
                                  $status = 'Failed';
                                }
                            } elseif($sending_server['type'] == 'sendgrid_api') {
                                try {
                                  SendGridService::send(json_decode($sending_server['sending_attributes'])->api_key,
                                  $from_email, $from_name, $contact->email, $reply_email, $email_subject, $content, 'html', $message_id,
                                  );
                                  $status = 'Sent';
                                } catch(\Exception $e) {
                                  \Log::error('run:drips-sendgrid => '.$e->getMessage());
                                  $status = 'Failed';
                                }
                            } elseif($sending_server['type'] == 'elastic_email_api') {
                                try {
                                  ElasticEmailService::send(json_decode($sending_server['sending_attributes'])->api_key,
                                    $from_email, $from_name, $contact->email, $reply_email, $email_subject, $content, $message_id
                                  );
                                  $status = 'Sent';
                                } catch(\Exception $e) {
                                  \Log::error('run:drips-elastic_email => '.$e->getMessage());
                                  $status = 'Failed';
                                }
                            } elseif($sending_server['type'] == 'postal_api') {
                              try {
                                $result = \App\Services\PostalAPIService::send(
                                    json_decode($sending_server['sending_attributes'])->postal_server_url,
                                    json_decode($sending_server['sending_attributes'])->api_key,
                                    $from_email, $from_name, $contact->email, $reply_email, $email_subject, $content, 'html', $message_id
                                );
                                if($result === 'send') {
                                    $status = 'Sent';
                                } else {
                                    $status = 'Failed';
                                }
                              } catch(\Exception $e) {
                                \Log::error('run:drips-postal => '.$e->getMessage());
                                $status = 'Failed';
                              }
                            }

                            // Should be check in both case
                            //if($status == 'Sent') {
                              $sending_server_data = Helper::updateSendingServerCounters($sending_server['id']);
                            //}

                              if($sending_server_data['sending_server_paused']) {
                                $load_sending_servers = true;
                              }

                            // Update status
                            DripScheduleStatLog::whereId($drip_schedule_stat_log->id)->update(['status' => $status]);

                            if($wait) sleep($wait);
                        } else {
                          // If sending server connection failed then need to update it as system inactive
                          // Removing single and double quote due to output issue with js alert at frontend 
                          SendingServer::whereId($sending_server['id'])->update(['status' => 'System Inactive', 'notification' => str_replace( ["'",'"'], '', explode('.',$connection['msg'])[0] )]);

                          $load_sending_servers = true;
                        }

                        if($load_sending_servers) {
                          // Retrun new array of sending servers after make a sending server as system inactive
                          $sending_servers_data = SendingServer::getActiveSeningServers($sending_server_ids, 'array');

                          // If no sending server then no need to do anything
                          if(empty($sending_servers_data)) {
                            exit;
                          }
                        }

                        // Must exit from drip loop, mail already send to last possible drip;
                        break;
                      }
                    }
                  }
                });
            }
            // Next cron should enterin this drip schedule now
            DripSchedule::whereId($drip_schedule->id)->update(['in_progress' => false]);
          }
        }
    }
}
