<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\JsonResponse;
use Illuminate\View\View;
use App\Models\EmailsPage;
use App\Http\Helper\Helper;
use Auth;

class EmailPageController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(): View
    {
        $page = "contents_".request('type');
        $page_title = ucfirst(request('type')).'s';
        $breadcrumbs = [
            __('app.contents') => route('contents.index', ['type' => request('type')]),
            $page_title => route('contents.index', ['type' => request('type')]),
            __('app.manage') => '#'
        ];  
        return view('emails_pages.index',compact('page', 'page_title', 'breadcrumbs'));
    }

    /**
       * Retrun JSON datatable data
    */
    public function getEmailsPages(Request $request): Void
    {
        $result = EmailsPage::select('id', 'name', 'created_at')
            ->where('type', $request->type)
            ->app();

        $columns = ['id', 'id', 'name', 'created_at'];

        $data = Helper::dataFilters($request, $result, $columns);

        $result = $data['result'];
        $emails_pages = $result->get();

        $data =  Helper::datatableTotals($data['total']);

        foreach($emails_pages as $emails_pages) {
          $checkbox = "<input type=\"checkbox\" value=\"{$emails_pages->id}\" class=\"form-check-input\">";

          $actions = '<div class="btn-emails_pages">';
          $actions .= '<button type="button" class="btn btn-outline-primary dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">'.__('app.actions').'</button>';
          $actions .= '<ul class="dropdown-menu" style="">';          
          $actions.= '<li><a class="dropdown-item" href="'.route('contents.edit', [$emails_pages->id]).'"><i class="bi bi-pencil-square"></i> '.__('app.edit').'</a></li>';
          $actions .= '</ul>';

          $data['data'][] = [
            "DT_RowId" => "row_{$emails_pages->id}",
            $checkbox,
            $emails_pages->id,
            $emails_pages->name,
            $actions
          ];
        }
        echo json_encode($data);
    }


    /**
     * Show the form for editing the specified resource.
     */
    public function edit(int $id): View
    {
        $emails_pages = EmailsPage::whereId($id)->app()->first();
        $page = "contents_".$emails_pages->type;
        $page_title = ucfirst($emails_pages->type).'s';
        $breadcrumbs = [
            $page_title => route('contents.index', ['type' => request('type')]),
            __('app.edit') => '#'
        ];        
        return view('emails_pages.edit', compact('page', 'page_title', 'breadcrumbs', 'emails_pages'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, int $id): RedirectResponse
    {
        $input = $request->except('_token', 'name');

        $email_page = EmailsPage::findOrFail($id);

        if($email_page['slug'] == 'unsub-confirm') {
            if (strpos($input['content'], '[$unsub-confirm$]') === false) {
                return redirect()->back()
                    ->with('error', ($email_page->name . ' ' . __('app.alert_unsub_confirm')));
            }            
        }

        $email_page->fill($input)->save();

        return redirect()->back()
            ->with('success', ($email_page->name . ' ' . __('app.updated_successfully')));
    }

    /**
    * View page respectively 
    */
    public function showPage($slug, $contact_id=null, $stat_log_id=0, $type='c')
    {
        // If the unsubscribe confirmation link is clicked, the id will be passed as contact_id.
        if(!empty(request('id'))) {
            $contact_id = request('id');
        }
        // If call from receipent side
        if(!empty($contact_id)) {
          $contact = \App\Models\Contact::findOrFail(base64_decode($contact_id));
          $page = \App\Models\EmailsPage::whereSlug($slug)->whereAppId($contact->app_id)->first();

          $settings = \DB::table('settings')->whereId(config('custom.app_id'))->first();
          $data_values = [
            'sender-name'  => $settings->from_name,
            'sender-email' => $settings->from_email,
            'campaign-id'  => $stat_log_id,
            'type' => $type
          ];

          $data = Helper::replaceSpintags($page->content); // replace spintags
          $data = Helper::replaceCustomFields($data, $contact->customFields); // replace custom field
          $data = Helper::replaceSystemVariables($contact, $data, $data_values); // replace system variables
          $data = Helper::spinTaxParser($data); // replace spintax
          $data = Helper::defaultValueParser($data);
        } else {
          // else call from admin side to show page html
          $data = \App\Models\EmailsPage::whereSlug($slug)->whereAppId(Auth::user()->app_id)->value('content');
          $data = Helper::XSSReplaceTags(Helper::decodeString($data));
        }

        return view('includes.blank')->with('data', $data);
    }

}
