<?php

namespace App\Http\Helper;

class Helper
{

  /**
   * Retrun all timezones 
  */
  public static function timeZones($specific=null)
  {
    $timezones = [
      'Pacific/Midway'       => "(GMT-11:00) Midway Island, USA",
      'US/Samoa'             => "(GMT-11:00) Samoa, American Samoa",
      'US/Hawaii'            => "(GMT-10:00) Hawaii, USA",
      'US/Alaska'            => "(GMT-09:00) Alaska, USA",
      'US/Pacific'           => "(GMT-08:00) Pacific Time (US & Canada)",
      'America/Tijuana'      => "(GMT-08:00) Tijuana, Mexico",
      'US/Arizona'           => "(GMT-07:00) Arizona, USA",
      'US/Mountain'          => "(GMT-07:00) Mountain Time (US & Canada)",
      'America/Chihuahua'    => "(GMT-07:00) Chihuahua, Mexico",
      'America/Mazatlan'     => "(GMT-07:00) Mazatlan, Mexico",
      'America/Mexico_City'  => "(GMT-06:00) Mexico City, Mexico",
      'America/Monterrey'    => "(GMT-06:00) Monterrey, Mexico",
      'Canada/Saskatchewan'  => "(GMT-06:00) Saskatchewan, Canada",
      'US/Central'           => "(GMT-06:00) Central Time (US & Canada)",
      'US/Eastern'           => "(GMT-05:00) Eastern Time (US & Canada)",
      'US/East-Indiana'      => "(GMT-05:00) Indiana (East), USA",
      'America/Bogota'       => "(GMT-05:00) Bogota, Colombia",
      'America/Lima'         => "(GMT-05:00) Lima, Peru",
      'America/Caracas'      => "(GMT-04:30) Caracas, Venezuela",
      'Canada/Atlantic'      => "(GMT-04:00) Atlantic Time (Canada)",
      'America/La_Paz'       => "(GMT-04:00) La Paz, Bolivia",
      'America/Santiago'     => "(GMT-04:00) Santiago, Chile",
      'Canada/Newfoundland'  => "(GMT-03:30) Newfoundland, Canada",
      'America/Buenos_Aires' => "(GMT-03:00) Buenos Aires, Argentina",
      'Greenland'            => "(GMT-03:00) Greenland, Denmark",
      'Brasilia'            => "(GMT-03:00) Brasília, Brazil",
      'Atlantic/Stanley'     => "(GMT-02:00) Stanley, Falkland Islands",
      'Atlantic/Azores'      => "(GMT-01:00) Azores, Portugal",
      'Atlantic/Cape_Verde'  => "(GMT-01:00) Cape Verde Islands",
      'Africa/Casablanca'    => "(GMT) Casablanca, Morocco",
      'Europe/Dublin'        => "(GMT) Dublin, Ireland",
      'Europe/Lisbon'        => "(GMT) Lisbon, Portugal",
      'Europe/London'        => "(GMT) London, United Kingdom",
      'Africa/Monrovia'      => "(GMT) Monrovia, Liberia",
      'Europe/Amsterdam'     => "(GMT+01:00) Amsterdam, Netherlands",
      'Europe/Belgrade'      => "(GMT+01:00) Belgrade, Serbia",
      'Europe/Berlin'        => "(GMT+01:00) Berlin, Germany",
      'Europe/Bratislava'    => "(GMT+01:00) Bratislava, Slovakia",
      'Europe/Brussels'      => "(GMT+01:00) Brussels, Belgium",
      'Europe/Budapest'      => "(GMT+01:00) Budapest, Hungary",
      'Europe/Copenhagen'    => "(GMT+01:00) Copenhagen, Denmark",
      'Europe/Ljubljana'     => "(GMT+01:00) Ljubljana, Slovenia",
      'Europe/Madrid'        => "(GMT+01:00) Madrid, Spain",
      'Europe/Paris'         => "(GMT+01:00) Paris, France",
      'Europe/Prague'        => "(GMT+01:00) Prague, Czech Republic",
      'Europe/Rome'          => "(GMT+01:00) Rome, Italy",
      'Europe/Sarajevo'      => "(GMT+01:00) Sarajevo, Bosnia and Herzegovina",
      'Europe/Skopje'        => "(GMT+01:00) Skopje, North Macedonia",
      'Europe/Stockholm'     => "(GMT+01:00) Stockholm, Sweden",
      'Europe/Vienna'        => "(GMT+01:00) Vienna, Austria",
      'Europe/Warsaw'        => "(GMT+01:00) Warsaw, Poland",
      'Europe/Zagreb'        => "(GMT+01:00) Zagreb, Croatia",
      'Europe/Athens'        => "(GMT+02:00) Athens, Greece",
      'Europe/Bucharest'     => "(GMT+02:00) Bucharest, Romania",
      'Africa/Cairo'         => "(GMT+02:00) Cairo, Egypt",
      'Africa/Harare'        => "(GMT+02:00) Harare, Zimbabwe",
      'Europe/Helsinki'      => "(GMT+02:00) Helsinki, Finland",
      'Europe/Istanbul'      => "(GMT+02:00) Istanbul, Turkey",
      'Asia/Jerusalem'       => "(GMT+02:00) Jerusalem, Israel",
      'Europe/Kiev'          => "(GMT+02:00) Kyiv, Ukraine",
      'Europe/Minsk'         => "(GMT+02:00) Minsk, Belarus",
      'Europe/Riga'          => "(GMT+02:00) Riga, Latvia",
      'Europe/Sofia'         => "(GMT+02:00) Sofia, Bulgaria",
      'Europe/Tallinn'       => "(GMT+02:00) Tallinn, Estonia",
      'Europe/Vilnius'       => "(GMT+02:00) Vilnius, Lithuania",
      'Asia/Baghdad'         => "(GMT+03:00) Baghdad, Iraq",
      'Asia/Kuwait'          => "(GMT+03:00) Kuwait City, Kuwait",
      'Africa/Nairobi'       => "(GMT+03:00) Nairobi, Kenya",
      'Asia/Riyadh'          => "(GMT+03:00) Riyadh, Saudi Arabia",
      'Europe/Moscow'        => "(GMT+03:00) Moscow, Russia",
      'Asia/Tehran'          => "(GMT+03:30) Tehran, Iran",
      'Asia/Baku'            => "(GMT+04:00) Baku, Azerbaijan",
      'Europe/Volgograd'     => "(GMT+04:00) Volgograd, Russia",
      'Asia/Muscat'          => "(GMT+04:00) Muscat, Oman",
      'Asia/Tbilisi'         => "(GMT+04:00) Tbilisi, Georgia",
      'Asia/Yerevan'         => "(GMT+04:00) Yerevan, Armenia",
      'Asia/Kabul'           => "(GMT+04:30) Kabul, Afghanistan",
      'Asia/Karachi'         => "(GMT+05:00) Karachi, Pakistan",
      'Asia/Tashkent'        => "(GMT+05:00) Tashkent, Uzbekistan",
      'Asia/Kolkata'         => "(GMT+05:30) Kolkata, India",
      'Asia/Kathmandu'       => "(GMT+05:45) Kathmandu, Nepal",
      'Asia/Yekaterinburg'   => "(GMT+06:00) Ekaterinburg, Russia",
      'Asia/Almaty'          => "(GMT+06:00) Almaty, Kazakhstan",
      'Asia/Dhaka'           => "(GMT+06:00) Dhaka, Bangladesh",
      'Asia/Novosibirsk'     => "(GMT+07:00) Novosibirsk, Russia",
      'Asia/Bangkok'         => "(GMT+07:00) Bangkok, Thailand",
      'Asia/Jakarta'         => "(GMT+07:00) Jakarta, Indonesia",
      'Asia/Krasnoyarsk'     => "(GMT+08:00) Krasnoyarsk, Russia",
      'Asia/Chongqing'       => "(GMT+08:00) Chongqing, China",
      'Asia/Hong_Kong'       => "(GMT+08:00) Hong Kong, China",
      'Asia/Kuala_Lumpur'    => "(GMT+08:00) Kuala Lumpur, Malaysia",
      'Australia/Perth'      => "(GMT+08:00) Perth, Australia",
      'Asia/Singapore'       => "(GMT+08:00) Singapore",
      'Asia/Taipei'          => "(GMT+08:00) Taipei, Taiwan",
      'Asia/Ulaanbaatar'     => "(GMT+08:00) Ulaanbaatar, Mongolia",
      'Asia/Urumqi'          => "(GMT+08:00) Urumqi, China",
      'Asia/Irkutsk'         => "(GMT+09:00) Irkutsk, Russia",
      'Asia/Seoul'           => "(GMT+09:00) Seoul, South Korea",
      'Asia/Tokyo'           => "(GMT+09:00) Tokyo, Japan",
      'Australia/Adelaide'   => "(GMT+09:30) Adelaide, Australia",
      'Australia/Darwin'     => "(GMT+09:30) Darwin, Australia",
      'Asia/Yakutsk'         => "(GMT+10:00) Yakutsk, Russia",
      'Australia/Brisbane'   => "(GMT+10:00) Brisbane, Australia",
      'Australia/Canberra'   => "(GMT+10:00) Canberra, Australia",
      'Pacific/Guam'         => "(GMT+10:00) Guam, USA",
      'Australia/Hobart'     => "(GMT+10:00) Hobart, Australia",
      'Australia/Melbourne'  => "(GMT+10:00) Melbourne, Australia",
      'Pacific/Port_Moresby' => "(GMT+10:00) Port Moresby, Papua New Guinea",
      'Australia/Sydney'     => "(GMT+10:00) Sydney, Australia",
      'Asia/Vladivostok'     => "(GMT+11:00) Vladivostok, Russia",
      'Asia/Magadan'         => "(GMT+12:00) Magadan, Russia",
      'Pacific/Auckland'     => "(GMT+12:00) Auckland, New Zealand",
      'Pacific/Fiji'         => "(GMT+12:00) Fiji",
    ];
    return !empty($specific) ? $timezones[$specific] : $timezones;
  }

  /**
   * Retrun timezones offset
  */
  public static function timeZonesOffset($timezone)
  {
    $timezones = [
      'Pacific/Midway'       => "-11:00",
      'US/Samoa'             => "-11:00",
      'US/Hawaii'            => "-10:00",
      'US/Alaska'            => "-09:00",
      'US/Pacific'           => "-08:00",
      'America/Tijuana'      => "-08:00",
      'US/Arizona'           => "-07:00",
      'US/Mountain'          => "-07:00",
      'America/Chihuahua'    => "-07:00",
      'America/Mazatlan'     => "-07:00",
      'America/Mexico_City'  => "-06:00",
      'America/Monterrey'    => "-06:00",
      'Canada/Saskatchewan'  => "-06:00",
      'US/Central'           => "-06:00",
      'US/Eastern'           => "-05:00",
      'US/East-Indiana'      => "-05:00",
      'America/Bogota'       => "-05:00",
      'America/Lima'         => "-05:00",
      'America/Caracas'      => "-04:30",
      'Canada/Atlantic'      => "-04:00",
      'America/La_Paz'       => "-04:00",
      'America/Santiago'     => "-04:00",
      'Canada/Newfoundland'  => "-03:30",
      'America/Buenos_Aires' => "-03:00",
      'Greenland'            => "-03:00",
      'Atlantic/Stanley'     => "-02:00",
      'Atlantic/Azores'      => "-01:00",
      'Atlantic/Cape_Verde'  => "-01:00",
      'Africa/Casablanca'    => "+00:00",
      'Europe/Dublin'        => "+00:00",
      'Europe/Lisbon'        => "+00:00",
      'Europe/London'        => "+00:00",
      'Africa/Monrovia'      => "+00:00",
      'Europe/Amsterdam'     => "+01:00",
      'Europe/Belgrade'      => "+01:00",
      'Europe/Berlin'        => "+01:00",
      'Europe/Bratislava'    => "+01:00",
      'Europe/Brussels'      => "+01:00",
      'Europe/Budapest'      => "+01:00",
      'Europe/Copenhagen'    => "+01:00",
      'Europe/Ljubljana'     => "+01:00",
      'Europe/Madrid'        => "+01:00",
      'Europe/Paris'         => "+01:00",
      'Europe/Prague'        => "+01:00",
      'Europe/Rome'          => "+01:00",
      'Europe/Sarajevo'      => "+01:00",
      'Europe/Skopje'        => "+01:00",
      'Europe/Stockholm'     => "+01:00",
      'Europe/Vienna'        => "+01:00",
      'Europe/Warsaw'        => "+01:00",
      'Europe/Zagreb'        => "+01:00",
      'Europe/Athens'        => "+02:00",
      'Europe/Bucharest'     => "+02:00",
      'Africa/Cairo'         => "+02:00",
      'Africa/Harare'        => "+02:00",
      'Europe/Helsinki'      => "+02:00",
      'Europe/Istanbul'      => "+02:00",
      'Asia/Jerusalem'       => "+02:00",
      'Europe/Kiev'          => "+02:00",
      'Europe/Minsk'         => "+02:00",
      'Europe/Riga'          => "+02:00",
      'Europe/Sofia'         => "+02:00",
      'Europe/Tallinn'       => "+02:00",
      'Europe/Vilnius'       => "+02:00",
      'Asia/Baghdad'         => "+03:00",
      'Asia/Kuwait'          => "+03:00",
      'Africa/Nairobi'       => "+03:00",
      'Asia/Riyadh'          => "+03:00",
      'Europe/Moscow'        => "+03:00",
      'Asia/Tehran'          => "+03:30",
      'Asia/Baku'            => "+04:00",
      'Europe/Volgograd'     => "+04:00",
      'Asia/Muscat'          => "+04:00",
      'Asia/Tbilisi'         => "+04:00",
      'Asia/Yerevan'         => "+04:00",
      'Asia/Kabul'           => "+04:30",
      'Asia/Karachi'         => "+05:00",
      'Asia/Tashkent'        => "+05:00",
      'Asia/Kolkata'         => "+05:30",
      'Asia/Kathmandu'       => "+05:45",
      'Asia/Yekaterinburg'   => "+06:00",
      'Asia/Almaty'          => "+06:00",
      'Asia/Dhaka'           => "+06:00",
      'Asia/Novosibirsk'     => "+07:00",
      'Asia/Bangkok'         => "+07:00",
      'Asia/Jakarta'         => "+07:00",
      'Asia/Krasnoyarsk'     => "+08:00",
      'Asia/Chongqing'       => "+08:00",
      'Asia/Hong_Kong'       => "+08:00",
      'Asia/Kuala_Lumpur'    => "+08:00",
      'Australia/Perth'      => "+08:00",
      'Asia/Singapore'       => "+08:00",
      'Asia/Taipei'          => "+08:00",
      'Asia/Ulaanbaatar'     => "+08:00",
      'Asia/Urumqi'          => "+08:00",
      'Asia/Irkutsk'         => "+09:00",
      'Asia/Seoul'           => "+09:00",
      'Asia/Tokyo'           => "+09:00",
      'Australia/Adelaide'   => "+09:30",
      'Australia/Darwin'     => "+09:30",
      'Asia/Yakutsk'         => "+10:00",
      'Australia/Brisbane'   => "+10:00",
      'Australia/Canberra'   => "+10:00",
      'Pacific/Guam'         => "+10:00",
      'Australia/Hobart'     => "+10:00",
      'Australia/Melbourne'  => "+10:00",
      'Pacific/Port_Moresby' => "+10:00",
      'Australia/Sydney'     => "+10:00",
      'Asia/Vladivostok'     => "+11:00",
      'Asia/Magadan'         => "+12:00",
      'Pacific/Auckland'     => "+12:00",
      'Pacific/Fiji'         => "+12:00",
    ];
    return $timezones[$timezone];
  }

  /**
   * Retrun app bouce rules
  */
  public static function bouceCodes($code=null)
  {
    $bouce_codes = [
      '421' => ['type' => 'Soft', 'description' => 'Messages temporarily deferred due to unexpected volume or user complaints'],
      '520' => ['type' => 'Soft', 'description' => 'Other or undefined mailbox status'],
      '521' => ['type' => 'Soft', 'description' => 'Mailbox disabled, not accepting messages'],
      '522' => ['type' => 'Soft', 'description' => 'Mailbox full'],
      '531' => ['type' => 'Soft', 'description' => 'Mail system full'],
      '545' => ['type' => 'Soft', 'description' => 'Network congestion'],
      '553' => ['type' => 'Soft', 'description' => 'Too many recipients'],
      '500' => ['type' => 'Hard', 'description' => 'Address does not exist'],
      '510' => ['type' => 'Hard', 'description' => 'Other address status'],
      '511' => ['type' => 'Hard', 'description' => 'Bad destination mailbox address'],
      '512' => ['type' => 'Hard', 'description' => 'Bad destination system address'],
      '513' => ['type' => 'Hard', 'description' => 'Bad destination mailbox address syntax'],
      '514' => ['type' => 'Hard', 'description' => 'Destination mailbox address ambiguous'],
      '515' => ['type' => 'Hard', 'description' => 'Destination mailbox address valid'],
      '516' => ['type' => 'Hard', 'description' => 'Mailbox has moved'],
      '517' => ['type' => 'Hard', 'description' => 'Bad sender\’s mailbox address syntax'],
      '518' => ['type' => 'Hard', 'description' => 'Bad sender’s system address'],
      '523' => ['type' => 'Hard', 'description' => 'Message length exceeds administrative limit.'],
      '524' => ['type' => 'Hard', 'description' => 'Mailing list expansion problem'],
      '530' => ['type' => 'Hard', 'description' => 'Other or undefined mail system status'],
      '532' => ['type' => 'Hard', 'description' => 'System not accepting network messages'],
      '533' => ['type' => 'Hard', 'description' => 'System not capable of selected features'],
      '534' => ['type' => 'Hard', 'description' => 'Message too big for system'],
      '540' => ['type' => 'Hard', 'description' => 'Other or undefined network or routing status'],
      '541' => ['type' => 'Hard', 'description' => 'No answer from host'],
      '542' => ['type' => 'Hard', 'description' => 'Bad connection'],
      '543' => ['type' => 'Hard', 'description' => 'Routing server failure'],
      '544' => ['type' => 'Hard', 'description' => 'Unable to route'],
      '546' => ['type' => 'Hard', 'description' => 'Routing loop detected'],
      '547' => ['type' => 'Hard', 'description' => 'Delivery time expired'],
      '550' => ['type' => 'Hard', 'description' => 'Address does not exist'],
      '551' => ['type' => 'Hard', 'description' => 'Invalid command'],
      '552' => ['type' => 'Hard', 'description' => 'Syntax error'],
      '554' => ['type' => 'Hard', 'description' => 'Invalid command arguments'],
      '555' => ['type' => 'Hard', 'description' => 'Wrong protocol version'],
      '560' => ['type' => 'Hard', 'description' => 'Other or undefined media error'],
      '561' => ['type' => 'Hard', 'description' => 'Media not supported'],
      '562' => ['type' => 'Hard', 'description' => 'Conversion required and prohibited'],
      '563' => ['type' => 'Hard', 'description' => 'Conversion required but not supported'],
      '564' => ['type' => 'Hard', 'description' => 'Conversion with loss performed'],
      '565' => ['type' => 'Hard', 'description' => 'Conversion failed'],
      '570' => ['type' => 'Hard', 'description' => 'Other or undefined security status'],
      '571' => ['type' => 'Hard', 'description' => 'Delivery not authorized, message refused'],
      '572' => ['type' => 'Hard', 'description' => 'Mailing list expansion prohibited'],
      '573' => ['type' => 'Hard', 'description' => 'Security conversion required but not possible'],
      '574' => ['type' => 'Hard', 'description' => 'Security features not supported'],
      '575' => ['type' => 'Hard', 'description' => 'Cryptographic failure'],
      '576' => ['type' => 'Hard', 'description' => 'Cryptographic algorithm not supported'],
      '577' => ['type' => 'Hard', 'description' => 'Message integrity failure'],
      '605' => ['type' => 'Hard', 'description' => 'Not delivering to previously bounced address'],
      '911' => ['type' => 'Hard', 'description' => 'Hard bounce with no bounce code found. It could be an invalid email or rejected email from your mail server (such as from a sending limit).'],
      '4.2.1' => ['type' => 'Soft', 'description' => 'Messages temporarily deferred due to unexpected volume or user complaints'],
      '4.2.2' => ['type' => 'Soft', 'description' => 'mailbox full'],
      '5.2.0' => ['type' => 'Soft', 'description' => 'Other or undefined mailbox status'],
      '5.2.1' => ['type' => 'Soft', 'description' => 'Mailbox disabled, not accepting messages'],
      '5.2.2' => ['type' => 'Soft', 'description' => 'Mailbox full'],
      '5.3.1' => ['type' => 'Soft', 'description' => 'Mail system full'],
      '5.4.5' => ['type' => 'Soft', 'description' => 'Network congestion'],
      '5.5.3' => ['type' => 'Soft', 'description' => 'Too many recipients'],
      '5.0.0' => ['type' => 'Hard', 'description' => 'Address does not exist'],
      '5.1.0' => ['type' => 'Hard', 'description' => 'Other address status'],
      '5.1.1' => ['type' => 'Hard', 'description' => 'Bad destination mailbox address'],
      '5.1.2' => ['type' => 'Hard', 'description' => 'Bad destination system address'],
      '5.1.3' => ['type' => 'Hard', 'description' => 'Bad destination mailbox address syntax'],
      '5.1.4' => ['type' => 'Hard', 'description' => 'Destination mailbox address ambiguous'],
      '5.1.5' => ['type' => 'Hard', 'description' => 'Destination mailbox address valid'],
      '5.1.6' => ['type' => 'Hard', 'description' => 'Mailbox has moved'],
      '5.1.7' => ['type' => 'Hard', 'description' => 'Bad sender\’s mailbox address syntax'],
      '5.1.8' => ['type' => 'Hard', 'description' => 'Bad sender’s system address'],
      '5.2.3' => ['type' => 'Hard', 'description' => 'Message length exceeds administrative limit.'],
      '5.2.4' => ['type' => 'Hard', 'description' => 'Mailing list expansion problem'],
      '5.3.0' => ['type' => 'Hard', 'description' => 'Other or undefined mail system status'],
      '5.3.2' => ['type' => 'Hard', 'description' => 'System not accepting network messages'],
      '5.3.3' => ['type' => 'Hard', 'description' => 'System not capable of selected features'],
      '5.3.4' => ['type' => 'Hard', 'description' => 'Message too big for system'],
      '5.4.0' => ['type' => 'Hard', 'description' => 'Other or undefined network or routing status'],
      '5.4.1' => ['type' => 'Hard', 'description' => 'No answer from host'],
      '5.4.2' => ['type' => 'Hard', 'description' => 'Bad connection'],
      '5.4.3' => ['type' => 'Hard', 'description' => 'Routing server failure'],
      '5.4.4' => ['type' => 'Hard', 'description' => 'Unable to route'],
      '5.4.6' => ['type' => 'Hard', 'description' => 'Routing loop detected'],
      '5.4.7' => ['type' => 'Hard', 'description' => 'Delivery time expired'],
      '5.5.0' => ['type' => 'Hard', 'description' => 'Address does not exist'],
      '5.5.1' => ['type' => 'Hard', 'description' => 'Invalid command'],
      '5.5.2' => ['type' => 'Hard', 'description' => 'Syntax error'],
      '5.5.4' => ['type' => 'Hard', 'description' => 'Invalid command arguments'],
      '5.5.5' => ['type' => 'Hard', 'description' => 'Wrong protocol version'],
      '5.6.0' => ['type' => 'Hard', 'description' => 'Other or undefined media error'],
      '5.6.1' => ['type' => 'Hard', 'description' => 'Media not supported'],
      '5.6.2' => ['type' => 'Hard', 'description' => 'Conversion required and prohibited'],
      '5.6.3' => ['type' => 'Hard', 'description' => 'Conversion required but not supported'],
      '5.6.4' => ['type' => 'Hard', 'description' => 'Conversion with loss performed'],
      '5.6.5' => ['type' => 'Hard', 'description' => ' Conversion failed'],
      '5.7.0' => ['type' => 'Hard', 'description' => 'Other or undefined security status'],
      '5.7.1' => ['type' => 'Hard', 'description' => 'Delivery not authorized, message refused'],
      '5.7.2' => ['type' => 'Hard', 'description' => 'Mailing list expansion prohibited'],
      '5.7.3' => ['type' => 'Hard', 'description' => 'Security conversion required but not possible'],
      '5.7.4' => ['type' => 'Hard', 'description' => 'Security features not supported'],
      '5.7.5' => ['type' => 'Hard', 'description' => 'Cryptographic failure'],
      '5.7.6' => ['type' => 'Hard', 'description' => 'Cryptographic algorithm not supported'],
      '5.7.7' => ['type' => 'Hard', 'description' => 'Message integrity failure'],
      '9.1.1' => ['type' => 'Hard', 'description' => 'Hard bounce with no bounce code found. It could be an invalid email or rejected email from your mail server (such as from a sending limit).'],
    ];
    if(!empty($code)) {
      return (array_key_exists($code, $bouce_codes)) ? $bouce_codes[$code] : null;
    } else {
      return $bouce_codes;
    }
  }

  /**
   * Retrun all supported languages
  */
  public static function languages($language=null)
  {
    $languages = [
      'en' => 'English',
      'ar' => 'العربية',
      'es' => 'Español',
      'fr' => 'Français ',
      'de' => 'Deutsch',
      'it' => 'Italian',
      'ru' => 'русский',
      'zh' => '中文',
    ];

    if(!empty($language)) {
      return $languages[$language];
    }
    return $languages;
  }

  /**
   * Retrun all countries
  */
  public static function countries($country_code=null)
  {
    $countries = \DB::table('countries')->pluck('name', 'code'); // get countries;

    return !empty($country_code) ? $countries[$country_code] : $countries;
  }

  /**
   * Retrun all permissions
  */
  public static function systemPermissions()
  {
    return [ 
      [
        'title' => __('app.user_management'),
        'modules' => [
          [
            'title' => __('app.dashboard'),
            'permissions' => [
              'dashboard_cards' => __('app.dashboard_cards'),
              'dashboard_campaigns_stats' => __('app.dashboard_campaigns_chart'),
              'dashboard_calander' => __('app.dashboard_calander'),
              'dashboard_country_stats' => __('app.dashboard_country_stats'),
              'dashboard_domain_stats' => __('app.dashboard_domain_stats'),
            ]
          ],
          [
            'title' => __('app.lists'),
            'permissions' => [
              'add_new_list' => __('app.add_new_list'),
              'lists_manage' => __('app.lists_manage'),
              'list_export' => __('app.export'),
              'bulk_update' => __('app.bulk_update'),
              'suppression' => __('app.suppression'),
              'custom_fields' => __('app.custom_fields'),
              'email_verifiers' => __('app.email_verifiers'),
              'segmentation_list' => __('app.segmentation_list'),
            ]
          ],
          [
            'title' => __('app.campaigns'),
            'permissions' => [
              'add_new_campaign' => __('app.add_new_campaign'),
              'campaigns_manage' => __('app.campaigns_manage'),
              'drips' => __('app.drips'),
              'templates' => __('app.templates'),
              'spintags' => __('app.spintags'),
              'mail_headers' => __('app.mail_headers')
            ]
          ],
          [
            'title' => __('app.contacts'),
            'permissions' => [
              'add_new_contact' => __('app.add_new_contact'),
              'contacts_manage' => __('app.contacts_manage'),
              'contacts_import' => __('app.contacts_import'),
            ]
          ],
          [
            'title' => __('app.schedule'),
            'permissions' => [
              'schedule_campaigns' => __('app.campaigns_schedule'),
              'schedule_triggers' => __('app.triggers'),
              'schedule_split_tests' => __('app.split_test'),
            ]
          ],
          [
            'title' => __('app.servers'),
            'permissions' => [
              'delivery_servers' => __('app.delivery_servers'),
              'reply_servers' => __('app.reply_servers'),
              'bounce_servers' => __('app.bounce_servers'),
              'fbl_servers' => __('app.fbl_servers'),
              'warmup_plans' => __('app.warmup_plans')
            ]
          ],
          [
            'title' => __('app.mta'),
            'permissions' => [
              'pmta' => __('app.pmta')
            ]
          ],
          [
            'title' => __('app.domains'),
            'permissions' => [
              'sending_domains' => __('app.sending_domains'),
              'tracking_domains' => __('app.tracking_domains'),
            ]
          ],
          [
            'title' => __('app.contents'),
            'permissions' => [
              'contents_emails' => __('app.contents_emails'),
              'contents_pages' => __('app.contents_pages'),
              'webforms' => __('app.contents_webforms')
            ]
          ],
            [
            'title' => __('app.groups'),
            'permissions' => [
              'groups_grouplists' => __('app.groups_lists'),
              'groups_groupcampaigns' => __('app.groups_campaigns'),
              'groups_sending_groupservers' => __('app.deliver_servers'),
              'groups_sending_groupdomains' => __('app.sending_domains'),
              'groups_groupsuppression' => __('app.suppression'),
              'groups_groupdrips' => __('app.drips'),
              'groups_bounce_servers' => __('app.groups_bounce_servers'),
              'groups_reply_servers' => __('app.groups_reply_servers'),
              'groups_fbl_servers' => __('app.groups_fbl_servers'),
            ]
          ],
          /*[
            'title' => __('app.client_management'),
            'permissions' => [
              'clients_roles' => __('app.roles'),
              'clients_packages' => __('app.packages'),
              'clients' => __('app.clients'),
            ]
          ],*/
          [
            'title' => __('app.analatics'),
            'permissions' => [
              'analatics_campaigns' => __('app.campaigns'),
              'analatics_campaigns_delete' => __('app.campaigns'). ' '. __('app.delete'),
              'analatics_campaigns_export' => __('app.campaigns'). ' '. __('app.export'),
              'segmentation_campaign' => __('app.campaigns'). ' '. __('app.audience_filter'),
              'analatics_triggers' => __('app.triggers'),
              'analatics_triggers_export' => __('app.triggers'). ' '. __('app.export'),
              'analatics_split_tests' => __('app.split_tests'),
              'analatics_split_tests_export' => __('app.split_tests'). ' '. __('app.export'),
              'analatics_split_test_delete' => __('app.split_tests'). ' '. __('app.delete'),
            ]
          ],
          [
            'title' => __('app.miscellaneous'),
            'permissions' => [              
              'system_notifications' => __('app.notifications'),
              'activity_logs' => __('app.activity_logs'),
              'error_logs' => __('app.error_logs'),
              'php_info' => __('app.php_info'),
            ]
          ],
          [
            'title' => __('app.user_management'),
            'permissions' => [
              'roles' => __('app.roles'),
              'users' => __('app.users')
            ]
          ],
          [
            'title' => __('app.email_health'),
            'permissions' => [
              'system_bounced' => __('app.system_bounced'),
              'blacklisted_domains' => __('app.domain'),
              'blacklisted_ips' => __('app.ips'),
            ]
          ],
          [
            'title' => __('app.settings'),
            'permissions' => [
              /*'settings_applications' => __('app.application'),*/
              'settings_api' => __('app.api'),
              'settings_chatGPT' => __('app.chatGPT'),
              'settings_general' => __('app.general'),
            ]
          ],
          [
            'title' => __('app.organizer'),
            'permissions' => [
              'notes' => __('app.notes'),
            ]
          ],
          [
            'title' => __('app.tools'),
            'permissions' => [
              'image_manager' => __('app.image_manager')
            ]
          ],
          [
            'title' => __('app.top_menu'),
            'permissions' => [
              'languages' => __('app.language_menu'),
              'theme_layout' => __('app.theme_layout')
            ]
          ],          
        ]
      ]
    ];
  }

  /**
   * Verify a permission to the user
  */
  public static function checkPermissions($permission, $page = true)
  {
    // Exclued to check per missions for Super Admin user, which will awlasy 1
    if(\Auth::user()->id != 1 && !\Auth::user()->can($permission)) {
      if($page) {
        return abort(401);
      } else {
        return false;
      }
   }
   return true;
 }

  /*
   * Replace regular expression changing multiple spaces or hyphens with one hyphen:
  */
  public static function replaceHyphen($str)
  {
    return preg_replace('#[ -]+#', '-', $str);
  }

  /**
   * Retrun datetiem format for the app
  */
  public static function datetimeDisplay($datetime, $timezone = null)
  {
    $carbon = new \Carbon\Carbon($datetime);
    if(!empty($timezone))
      $carbon->setTimezone($timezone);
    else
      try {
        $carbon->setTimezone(\Auth::user()->timezone);
      } catch (\Exception $e) {
        
      }

    $datetime = $carbon->format('Y-m-d h:i A');
    return $datetime;
  }

  /**
   * Retrun limited data after filtration for datatables
  */
  public static function dataFilters($request, $result, $columns)
  {

    // If there is a search
    $keywords = $request->get('search')['value'] ?? '';
    if ($keywords != "") {
      $result->Where(function($query) use ($keywords, $columns) {
        foreach($columns as $column) {
          $query->orWhere($column, 'LIKE', "%{$keywords}%");
        }
      });
    }

    $total = $result->count();

    // For orders by
    if(!empty($request->get('order'))) {
      foreach($request->get('order') as $order) {
        $result->orderBy($columns[$order['column']], $order['dir']);
      }
    }

    $offset = $request->get('start') ?? 0;
    $limit = $request->get('length') ?? 50;
    $result->offset($offset)->limit($limit);

    $data = [
      'total' => $total,
      'result' => $result
    ];

    return $data;
  }

  /**
   * Retrun limited data after filtration for datatables
  */
  public static function datatableTotals($total) {
    return [
      "iTotalRecords" => $total,
      "iTotalDisplayRecords" => $total,
      "data" => []
    ];
  }

  /**
   * Retrun value after split for linebreak
  */
  public static function splitLineBreak($value)
  {
    return preg_split('/\r\n|[\r\n]/', $value);
  }

  /**
   * Retrun value after split for linebreak and comma
  */
  public static function splitLineBreakWithComma($value)
  {
    return preg_split('/\r\n|[\r\n,]+/', $value);
  }

  /**
   * Retrun date in db format
  */
  public static function dbDate($date) {
    return date('Y-m-d', strtotime(str_replace('/', '-', $date)));
  }

  /**
   * Create directory if not exist
  */
  public static function dirCreateOrExist($dir)
  {
   if(!is_dir($dir)) {
    if(!mkdir($dir, 0777, true)) {
      throw new Exception("Dir not created", 1);
    }
  }
}

  /**
   * Retrun .csv file headers
  */
  public static function getCsvFileHeader($file)
  {
    $csv = \League\Csv\Reader::createFromPath($file, 'r');
    $csv->setHeaderOffset(0);
    return $csv->getHeader();
  }

  /**
   * Retrun .csv file counts
  */
  public static function getCsvCount($file)
  {
    $csv = \League\Csv\Reader::createFromPath($file, 'r');
    return count($csv);
  }

  /**
   * Retrun dropdown for system shortcodes
  */
  public static function dropdownCustom($title, $data, $func)
  {
    $dropdown = '';
    $dropdown .= '<div class="btn-group">
    <button type="button" class="btn btn-primary btn-xs">'.$title.'</button>
    <button type="button" class="btn btn-primary btn-xs dropdown-toggle" data-toggle="dropdown" aria-expanded="false">
    <span class="caret"></span>
    </button>
    <ul class="dropdown-menu" role="menu">';
    foreach($data as $key => $val) {
      $dropdown .= "<li><a href='javascript:;' onclick=\"{$func}('$key');\">$val</a></li>";
    }
    $dropdown .= '</ul>
    </div>';
    return $dropdown;
  }

  /**
   * Retrun system variables
  */
  public static function systemVariables()
  {
    return [
      'unsub-link' => 'Unsubscribe Link',
      'unsub-confirm' => 'Unsubscribe Link Confirm',
      'list-id' => 'List ID',
      'list-name' => 'List Name',
      'sender-name' => 'Sender Name',
      'sender-email' => 'Sender Email',
      'receiver-email' => 'Receiver Email',    
      'todays-date' => 'Todays Date',
      'message-id' => 'Message-ID',
      'contact-id' => 'Contact-ID',
      
    ];
  }

  /**
   * Retrun app shortcodes
  */
  public static function shortcodes($section='all')
  {
    $shortcodes = '<style>
/* Override any conflicting CSS from schedule.css or smart_wizard CSS */
.modal-dialog.modal-lg {
  max-width: 800px !important;
  width: 90% !important;
  margin: 1.75rem auto !important;
}

.modal-content {
  border-radius: 0.5rem !important;
  box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15) !important;
}

.modal-body {
  max-height: 70vh !important;
  overflow-y: auto !important;
  padding: 1rem !important;
  scrollbar-width: thin !important;
  scrollbar-color: #888 #f0f0f0 !important;
}

/* Professional shortcode buttons */
.modal .btn-outline-primary.btn-sm {
  border-radius: 0.375rem !important;
  font-size: 0.75rem !important;
  padding: 0.375rem 0.75rem !important;
  margin: 0.125rem !important;
  transition: all 0.15s ease-in-out !important;
}

.modal .btn-outline-primary.btn-sm:hover {
  background-color: var(--bs-primary) !important;
  border-color: var(--bs-primary) !important;
  color: white !important;
}

/* Section headers */
.modal .fw-bold {
  font-size: 0.875rem !important;
  font-weight: 600 !important;
  color: var(--bs-primary) !important;
  margin-top: 1rem !important;
  margin-bottom: 0.5rem !important;
  padding-bottom: 0.25rem !important;
  border-bottom: 1px solid var(--bs-border-color) !important;
}

/* Grid layout improvements */
.modal .row {
  margin: 0 !important;
}

.modal .col-md-3 {
  padding: 0.25rem !important;
}

/* Search input styling */
.modal #shortcode-textbox {
  border-radius: 0.375rem !important;
  border: 1px solid var(--bs-border-color) !important;
  font-size: 0.875rem !important;
}

.modal #shortcode-textbox:focus {
  border-color: var(--bs-primary) !important;
  box-shadow: 0 0 0 0.2rem rgba(var(--bs-primary-rgb), 0.25) !important;
}
</style>';
    
    $shortcodes .= 
    '<div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-lg">
    <div class="modal-content">
    <div class="modal-header">
      <div class="d-flex align-items-center">
        <div class="p-2 border border-primary border-opacity-10 bg-primary-transparent rounded-circle me-3">
          <span class="avatar avatar-sm avatar-rounded bg-primary svg-white">
            <i class="bi bi-code"></i>
          </span>
        </div>
        <h6 class="modal-title mb-0 fw-semibold">'.__('app.shortcodes').'</h6>
      </div>
      <div class="d-flex align-items-center gap-2">
        &nbsp;<input id="shortcode-textbox" type="text" class="form-control" style="width: 200px;" placeholder="'.__('app.search_shortcodes').'">
      </div>
      <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="'.__('app.close').'"></button>
    </div>
    <div class="modal-body">
      <div class="row">';
    
    if($section == 'all') {
      $shortcodes .= Helper::shortcodesSystemVariables();
    }
    if($section == 'all') {
      $shortcodes .= Helper::shortcodesCustomFields();
    }
    if($section == 'all' || $section == 'spintags') {
      $shortcodes .= Helper::shortcodesSpintags();
    }

    if($section == 'all') {
      $shortcodes .= Helper::shortcodesSpintax();
    }

    if($section == 'all') {
      $shortcodes .= Helper::shortcodesRssFeed();
    }

    $shortcodes .= '</div></div>';

    $shortcodes .= '<div class="modal-footer">
      <button type="button" class="btn btn-light" data-bs-dismiss="modal">
        <i class="bi bi-arrow-left me-1"></i>'.__('app.close').'
      </button>
    </div>';

    $shortcodes .= '</div>';

    return $shortcodes;
  }


  /**
   * Retrun custom fields shortcodes
  */
  public static function shortcodesRssFeed()
  {
    $shortcodes = '<span class="fw-bold mt-2">'.__('app.rss_feed').'</span>';
    $shortcodes .= "<div class='col-md-12 mt-2'>".__('app.rss_feed_help')."</div>";
    $shortcodes .= "<div class='col-md-12 mt-1'>[RSSFEEDURL: https://example.com/rss RSSFEEDCOUNT:5]</div>";
    return $shortcodes;
  }

  /**
   * Retrun custom fields shortcodes
  */
  public static function shortcodesSpintax()
  {
    $shortcodes = '<span class="fw-bold mt-2">'.__('app.spintax').'</span>';
    $shortcodes .= "<div class='col-md-12 mt-2'>".__('app.help_spintax')."</div>";
    $shortcodes .= "<div class='col-md-12 mt-1'>[Random: hi|hello|hey]</div>";
    $shortcodes .= "<div class='col-md-12 mt-1'>[Random: good|better]</div>";

    $shortcodes .= '<span class="fw-bold mt-2">'.__('app.default_shortcode').'</span>';
    $shortcodes .= "<div class='col-md-12 mt-1'>[Default: there|Jhon]</div>";
    
    return $shortcodes;
  }

  /**
   * Retrun custom fields shortcodes
  */
  public static function shortcodesSystemVariables()
  {
    $system_variables = Helper::systemVariables();
    $shortcodes = '<span class="fw-bold">'.__('app.system_variables').'</span>';
    foreach($system_variables as $key => $val) {
      // no need to display unsub-confirm link it will confuse customer
      if($key == 'unsub-confirm') continue;
      
      $shortcode = "[\${$key}$]";
      $shortcodes .= "<div class='col-md-3' style='padding-bottom: 3px; padding-top:3px;'>
        <div class='card custom-card h-90'>
          <div class='card-body p-2'>
            <div class='text-center'>
              <h6 class='mb-1 fs-12 fw-semibold'>$val</h6>
              <small class='mb-2 d-block'>[\${$key}$]</small>
              <div class='d-flex gap-1 justify-content-center'>
                <button class='btn btn-outline-primary btn-sm' onclick=\"systemVariables('$shortcode');\" title='".__('app.click_to_insert_tag')."'>
                  <i class='bi bi-arrow-down-circle'></i>
                </button>
                <button class='btn btn-outline-secondary btn-sm' onclick=\"copyShortcode('$shortcode');\" title='".__('app.copy_shortcode')."'>
                  <i class='bi bi-copy'></i>
                </button>
              </div>
            </div>
          </div>
        </div>
      </div>";
    }
    return $shortcodes;
  }

  /**
   * Retrun custom fields shortcodes
  */
  public static function shortcodesCustomFields()
  {
    
    $shortcodes = '<span class="fw-bold mt-2">'.__('app.custom_fields').'</span>';

  //  $client_lists = Helper::getClientAttributeValue(\Auth::user()->app_id, 'list_ids');

    if(!empty($client_lists)) {
      $client_lists = \App\Models\Lists::whereIn('id', $client_lists)
        ->with('customFields')
        ->get();
      foreach($client_lists as $list) {
        $custom_fields = $list->customFields;
        
        if(count($custom_fields) > 0) {
          foreach($custom_fields as $key => $val) {
            $shortcode = "[#{$val->tag}#]";
            $shortcodes .= "<div class='col-md-3' style='padding-bottom: 3px; padding-top:3px;'>
              <div class='card custom-card h-90'>
                <div class='card-body p-2'>
                  <div class='text-center'>
                    <h6 class='mb-1 fs-12 fw-semibold'>$val->name</h6>
                    <small class='mb-2 d-block'>[#{$val->tag}#]</small>
                    <div class='d-flex gap-1 justify-content-center'>
                      <button class='btn btn-outline-primary btn-sm' onclick=\"customFields('$shortcode');\" title='".__('app.click_to_insert_tag')."'>
                        <i class='bi bi-arrow-down-circle'></i>
                      </button>
                      <button class='btn btn-outline-secondary btn-sm' onclick=\"copyShortcode('$shortcode');\" title='".__('app.copy_shortcode')."'>
                        <i class='bi bi-copy'></i>
                      </button>
                    </div>
                  </div>
                </div>
              </div>
            </div>";
          }
        }
      }
    }

    $custom_fields = \App\Models\CustomField::whereAppId(\Auth::user()->app_id)->pluck('name', 'tag');
    if(count($custom_fields) > 0) {
      foreach($custom_fields as $key => $val) {
        $shortcode = "[#{$key}#]";
        $shortcodes .= "<div class='col-md-3' style='padding-bottom: 3px; padding-top:3px;'>
          <div class='card custom-card h-90'>
            <div class='card-body p-2'>
              <div class='text-center'>
                <h6 class='mb-1 fs-12 fw-semibold'>$val</h6>
                <small class='mb-2 d-block'>[#{$key}#]</small>
                <div class='d-flex gap-1 justify-content-center'>
                  <button class='btn btn-outline-primary btn-sm' onclick=\"customFields('$shortcode');\" title='".__('app.click_to_insert_tag')."'>
                    <i class='bi bi-arrow-down-circle'></i>
                  </button>
                  <button class='btn btn-outline-secondary btn-sm' onclick=\"copyShortcode('$shortcode');\" title='".__('app.copy_shortcode')."'>
                    <i class='bi bi-copy'></i>
                  </button>
                </div>
              </div>
            </div>
          </div>
        </div>";
      }
    } else {
      $shortcodes .= "<div class='col-md-12'>".__('app.no_record_found')."</div>";
    }
    return $shortcodes;
  }

  /**
   * Retrun spintag shortcodes
  */
  public static function shortcodesSpintags()
  {
    $spintags = \App\Models\Spintag::whereAppId(\Auth::user()->app_id)->pluck('name', 'tag');
    $shortcodes = '<span class="fw-bold mt-2">'.__('app.spintags').'</span>';
    if(count($spintags) > 0) {
      foreach($spintags as $key => $val) {
        $shortcode = "[%{$key}%]";
        $shortcodes .= "<div class='col-md-3' style='padding-bottom: 3px; padding-top:3px;'>
          <div class='card custom-card h-90'>
            <div class='card-body p-2'>
              <div class='text-center'>
                <h6 class='mb-1 fs-12 fw-semibold'>$val</h6>
                <small class='mb-2 d-block'>[%{$key}%]</small>
                <div class='d-flex gap-1 justify-content-center'>
                  <button class='btn btn-outline-primary btn-sm' onclick=\"spinTags('$shortcode');\" title='".__('app.click_to_insert_tag')."'>
                    <i class='bi bi-arrow-down-circle'></i>
                  </button>
                  <button class='btn btn-outline-secondary btn-sm' onclick=\"copyShortcode('$shortcode');\" title='".__('app.copy_shortcode')."'>
                    <i class='bi bi-copy'></i>
                  </button>
                </div>
              </div>
            </div>
          </div>
        </div>";
      }
    } else {
      $shortcodes .= "<div class='col-md-12'>".__('app.no_record_found')."</div>";
    }
    return $shortcodes;
  }

  // Function to parse the Spintax pattern and replace it with random choices
  public static function spinTaxParser($text)
  {
      return preg_replace_callback(
          '/\[Random:\s*([^\]]+)\]/', // Regex pattern to match [Random: choice1|choice2|...]
          function($matches) {
              $choices = explode('|', $matches[1]); // Split choices by '|'
              return $choices[array_rand($choices)]; // Return a random choice
          },
          $text
      );
  }

  // function Set Default value via shortcode
  public static function defaultValueParser($input)
  {
    // Match the [Default: defaultValue|optionalName] pattern
    return preg_replace_callback(
        '/\[Default: (.+?)\|(.+?)?\]/',
        function ($matches) {
            $defaultValue = $matches[1]; // Default value (e.g., "there")
            $name = trim($matches[2] ?? '');  // Optional name (e.g., "Imran")
            
            // Use the name if present; otherwise, use the default value
            return !empty($name) ? $name : $defaultValue;
        },
        $input
    );
}

  /**
   * Retrun public and private key with 1024 bits
  */
  public static function generateKeys()
  {
    try {
      $key_pair = openssl_pkey_new([
        'digest_alg'       => 'sha1',
        "private_key_bits" => 1024,
        "private_key_type" => OPENSSL_KEYTYPE_RSA,
      ]);
      openssl_pkey_export($key_pair, $private_key);
      $detail = openssl_pkey_get_details($key_pair);
      $public_key = trim(preg_replace('/\s+/', '', $detail['key'])); // remove space etc if exist
      //$public_key = "v=DKIM1; k=rsa; p=" . $public_key;
    } catch (\Exception $e) {
      $private_key = $public_key = 'None';
    }
    $keys = [
      'private_key' => $private_key,
      'public_key' => $public_key
    ];
    return $keys;
  }

  /**
   * Retrun the email verifiers that supported by the app
  */
  public static function emailVerifiers($name = null)
  {
    $email_verifiers = [
      'relayzo' => 'Relayzo (Beta)',
      'kickbox' => 'Kickbox',
      //'neverbounce' => 'NeverBounce',
      //'bulkemailchecker' => 'BulkEmailChecker',
      'sendgrid' => 'SendGrid',
      'mailgun' => 'Mailgun',
    ];

    return empty($name) ? $email_verifiers : $email_verifiers[$name];
  }

  /**
   * Retrun the sending servers that supported by the app
  */
  public static function sendingServers($name = null)
  {
    $sending_servers = [
      'php_mail' => 'PHP Mail',
      'smtp' => 'SMTP',
      'gmail' => 'Gmail',
      'microsoft' => 'Outlook / Office 365',
      'amazon_ses_api' => 'Amazon SES API',
      'mailgun_api' => 'Mailgun API',
      'sparkpost_api' => 'SparkPost API',
      'sendgrid_api' => 'SendGrid API',
      'elastic_email_api' => 'Elastic Email API',
      'postal_api' => 'Postal API',
    ];

    return empty($name) ? $sending_servers : $sending_servers[$name];
  }


  /**
   * Retrun app supported sending servers that supported by the framework
  */
  public static function sendingServersFramworkSuported()
  {
    return [
      'php_mail',
      'smtp',
      'gmail',
      'microsoft',
      'amazon_ses_api',
      'mailgun_api',
      'sparkpost_api'
    ];
  }

  /**
   * Check sending server limit and return data can be use for update
  */
  public static function checkSendingServerLimit($speed_attributes, $hourly_sent, $daily_sent, $sending_server_id = null)
  {
    $sending_server_paused = false;
    $data = null;
    if($speed_attributes->speed == 'limited' || $speed_attributes->speed == 'warmup') {
      if($speed_attributes->duration == 'hourly') {
        if($hourly_sent >= $speed_attributes->limit) {
          $data['status'] = 'System Paused';
          $data['hourly_sent_next_timestamp'] = \Carbon\Carbon::now()->addHour(1);
          $data['notification'] = __('app.msg_hourly_limit');
          $sending_server_paused = true;
        }
      } elseif($speed_attributes->duration == 'daily') {
        if($daily_sent >= $speed_attributes->limit) {
          $data['status'] = 'System Paused';
          $data['daily_sent_next_timestamp'] = \Carbon\Carbon::now()->addDay(1);
          $data['notification'] = __('app.msg_daily_limit');
          $sending_server_paused = true;

          if($speed_attributes->speed == 'warmup') {
            // Always set warmup notification first
            $data['notification'] = __('app.msg_warmup_limit');
            
            // update limit for next schedule
            $schedule = \App\Models\WarmupPlan::whereId($speed_attributes->warmup_plan)->value('schedule');
            if(!empty($schedule)) {
              $warmup_day = $speed_attributes->warmup_day+1;
              $new_limit =  json_decode($schedule)[$warmup_day] ?? null;
            } else {
              $new_limit = null;
            }

            if(!empty($new_limit)) {
              \DB::table('sending_servers')->whereId($sending_server_id)->update([
                'speed_attributes->limit' => $new_limit,
                'speed_attributes->warmup_day' => $warmup_day
              ]);

            } else {
              // Warmup complete - set to unlimited
              \DB::table('sending_servers')->whereId($sending_server_id)->update([
                'speed_attributes->speed' => 'unlimited'
              ]);
              $data['notification'] = __('app.msg_warmup_complete');
            }
          }
        }
      }
    }

    return [
      'data' => $data,
      'sending_server_paused' => $sending_server_paused
    ];
  }

  /**
   * Update sending server limits counters and return array
  */
  public static function updateSendingServerCounters($id)
  {
    $sending_server = \App\Models\SendingServer::findOrFail($id);

    // Update sending server data
    $sending_server_data['total_sent']  = $sending_server->total_sent+1;
    $sending_server_data['hourly_sent'] = $sending_server->hourly_sent+1;
    $sending_server_data['daily_sent']  = $sending_server->daily_sent+1;

    $speed_attributes = json_decode($sending_server->speed_attributes);
    $sending_server_additional_data = Helper::checkSendingServerLimit($speed_attributes, $sending_server_data['hourly_sent'], $sending_server_data['daily_sent'], $id);

    if(!empty($sending_server_additional_data['data'])) {
      $sending_server_data = array_merge($sending_server_data, $sending_server_additional_data['data']);
    }

    // for warmup sending
    if($speed_attributes->speed == 'warmup') {
      // it will get paused seconds ((day hours/limit) * 60) * 60
      $pause_seconds = ceil(((24 / $speed_attributes->limit) * 60)*60);
      $sending_server_data['next_send_timestamp'] = \Carbon\Carbon::now()->addSeconds($pause_seconds);
      $pasue_sending_server = true;
    } else {
      $sending_server_data['next_send_timestamp'] = \Carbon\Carbon::now();
      $pasue_sending_server = false;
    }

    // Need to update server servers counters and data, after succcessful sent
    \App\Models\SendingServer::whereId($sending_server->id)->update($sending_server_data);

    $sending_server_data['sending_server_paused'] = $sending_server_additional_data['sending_server_paused'];

    // overwride the pause functionality due to warmup next time send
    if($pasue_sending_server) {
      $sending_server_data['sending_server_paused'] = true;
    }


    return $sending_server_data;
  }

  /**
   * Retrun amazon regions
  */
  public static function amazonRegions()
  {
    return [
      'us-east-1' => 'US East (N. Virginia)',
      'us-east-2' => 'US East (Ohio)',      
      'us-west-1' => 'US West (N. California)',
      'us-west-2' => 'US West (Oregon)',
      'ap-south-1' => 'Asia Pacific (Mumbai)',
      'ap-northeast-3' => 'Asia Pacific (Osaka-Local)',
      'ap-northeast-2' => 'Asia Pacific (Seoul)',
      'ap-southeast-1' => 'Asia Pacific (Singapore)',
      'ap-southeast-2' => 'Asia Pacific (Sydney)',
      'ap-northeast-1' => 'Asia Pacific (Tokyo)',
      'ca-central-1' => 'Canada (Central)',
      'cn-north-1' => 'China (Beijing)',
      'cn-northwest-1' => 'China (Ningxia)',
      'eu-central-1' => 'EU (Frankfurt)',
      'eu-west-1' => 'EU (Ireland)',
      'eu-west-2' => 'EU (London)',
      'eu-west-3' => 'EU (Paris)',
      'eu-north-1' => 'EU (Stockholm)',
      'sa-east-1' => 'South America (São Paulo)',
    ];
  }

  /**
   * Retrun app url
   * @param boolean
  */
  public static function getAppURL($without_protocol=null)
  {
    $app_url = \DB::table('settings')->where('id', config('custom.app_id'))->value('app_url');
    return $without_protocol ? parse_url($app_url, PHP_URL_HOST) : $app_url;
  }

  /**
   * Retrun Message-ID
  */
  public static function getCustomMessageID($domain = null)
  { 
    $domain = empty($domain) ? Helper::getAppURL() : $domain;
    $domain = str_replace('www.', '', $domain); // Remove www for url if any
    return sprintf('%s@%s', md5(Helper::uniqueID()), parse_url($domain, PHP_URL_HOST));
  }

  /**
   * Retrun Sending Domain with protocole extract from from_email
  */
  public static function getSendingDomainFromEmail($from_email)
  {
    $domain = explode('@', $from_email)[1];
    return \DB::table('sending_domains')->whereDomain($domain)->first();
  }

  /**
   * Retrun Unique-ID
  */
  public static function uniqueID()
  {
    return uniqid(time());
  } 

  /**
   * Retrun status after try to connect with sending server
  */
  public static function configureSendingNode($type, $attributes, $message_id=null)
  {
    $msg = 'success';
    $success = true;
    $transport = 'No sending transport available.';
    $sending_attributes = json_decode($attributes, true);
    if($type == 'php_mail') {
      try{
        $transport = new \Symfony\Component\Mailer\Transport\SendmailTransport();
      } catch(\Exception $e) {
        $message = explode('[', $e->getMessage());
        $msg = $message[0];
        $success = false;
        \Log::error('helper:configureSendingNode:php-mail => '.$e->getMessage());
      }
    } elseif($type == 'smtp' || $type == 'gmail' || $type == 'microsoft') {
        try {
            $smtpHost = trim($sending_attributes['host']);
            $smtpPort = trim($sending_attributes['port']); 
            $smtpEncryption = trim($sending_attributes['encryption']);  // e.g., 'tls'
            $smtpUsername = rawurlencode($sending_attributes['username']);  
            $smtpPassword = rawurlencode(\Crypt::decrypt($sending_attributes['password']));  
            if ($smtpEncryption == 'none') {
                $dsnString = sprintf('smtp://%s:%s@%s:%d', $smtpUsername, $smtpPassword, $smtpHost, $smtpPort);
            } else {
                 $dsnString = sprintf('smtp://%s:%s@%s:%d?encryption=%s', $smtpUsername, $smtpPassword, $smtpHost, $smtpPort, $smtpEncryption);
            }
            $transport = \Symfony\Component\Mailer\Transport::fromDsn($dsnString);

        } catch (\Exception $e) {
            $message = explode('[', $e->getMessage());
            $msg = $message[0];
            $success = false;
            \Log::error('helper:configureSendingNode:smtp => '.$e->getMessage());
        }
    } elseif($type == 'sparkpost_api') {
      $transport = new \Stidges\SparkpostTransport\SparkpostTransport(
        new \GuzzleHttp\Client(),
        urlencode(\Crypt::decrypt($sending_attributes['api_key'])),
        'api.sparkpost.com'
      );
    } elseif($type == 'mailgun_api') {
      $apiKey = urlencode(\Crypt::decrypt($sending_attributes['api_key']));
      $domain = $sending_attributes['domain'];
      $transport = new \Symfony\Component\Mailer\Bridge\Mailgun\Transport\MailgunApiTransport($apiKey, $domain);
    } elseif($type == 'amazon_ses_api') {
      $awsKey = $sending_attributes['access_key'];
      $awsSecret = urlencode(\Crypt::decrypt($sending_attributes['secret_key']));
      $awsRegion = $sending_attributes['region'];
      $dsnString = sprintf(
          'ses+https://%s:%s@default?region=%s',
          $awsKey,
          $awsSecret,
          $awsRegion
      );
      $transport = \Symfony\Component\Mailer\Transport::fromDsn($dsnString);
    }

    return [
      'transport' => $transport,
      'success' => $success,
      'msg' => $msg
    ];
}

  /**
   * Retrun basic configuration for sending an email
  */
  public static function configureEmailBasicSettings($sending_server)
  {
    if(!empty($sending_server->reply_email)) {
      $reply_email = Helper::replaceSpintags($sending_server['reply_email']);
      $reply_email = filter_var($reply_email, FILTER_VALIDATE_EMAIL) ? $reply_email : null;
    } else {
      $reply_email = null;
    }

    if($sending_server->type == 'sendgrid_api') {
      $message = new \SendGrid\Mail\Mail();
      $message->setFrom($sending_server->from_email, Helper::decodeString($sending_server->from_name));
      !empty($reply_email) ? $message->setReplyTo($reply_email) : '';
      return $message;
    } else {
      $message = new \Symfony\Component\Mime\Email();
      $message->from(new \Symfony\Component\Mime\Address($sending_server->from_email, $sending_server->from_name));
      !empty($reply_email) ? $message->replyTo($reply_email) : '';
      !empty($sending_server->bounce->email) ? $message->returnPath($sending_server->bounce->email) : '';
      return $message;
    }
  }

  /**
   * Attach dkim sign
  */
  public static function attachSigner($message, $privateKey, $sending_domain, $selector)
  {
    return $message->attachSigner((new \Swift_Signers_DKIMSigner($privateKey, $sending_domain, $selector))
      ->setBodyCanon('simple')
      ->ignoreHeader('Return-Path')
      ->setHeaderCanon('relaxed')
      ->setHashAlgorithm('rsa-sha1')
    );
  }

  /**
   * Retrun percentage
  */
  public static function getPercentage($processed, $total)
  {
    $total = !empty($total) ? $total : 1; // avoid to divid with zero
    return round(($processed * 100) / $total, 2) . ' %';
  }

  /**
   * Retrun percent of data
  */
  public static function getPercentOfData($percentage, $total)
  {
    return ceil(($percentage/100)*$total);
  }

  /**
   * Retrun strintg after replace the system variables shortcodes
  */
  public static function replaceSystemVariables($contact, $data, $data_values)
  {
    $system_variables = Helper::systemVariables();
    $system_variables_shortcodes = [];
    foreach($system_variables as $key => $val) {
     array_push($system_variables_shortcodes, "[\${$key}$]");
   }

   $data_values['contact-id'] = !empty($contact->id) ? $contact->id : '';

   $list_id = !empty($contact->list_id) ? $contact->list_id : '';
   $list_name = !empty($contact->list->name) ? $contact->list->name : '';
   $receiver_email = !empty($contact->email) ? $contact->email : '';
   $campaign_id = !empty($data_values['campaign-id']) ? $data_values['campaign-id'] : 0;
   $type = !empty($data_values['type']) ? $data_values['type'] : '';
   $campaign_name = !empty($data_values['campaign-name']) ? $data_values['campaign-name'] : '';
   $sender_name = !empty($data_values['sender-name']) ? $data_values['sender-name'] : '';
   $sender_email = !empty($data_values['sender-email']) ? $data_values['sender-email'] : '';
   $message_id = !empty($data_values['message-id']) ? $data_values['message-id'] : '';
   $todays_date = date("F j, Y");
   $contact_id = !empty($data_values['contact-id']) ? $data_values['contact-id'] : '';

   // $data_values['confirm-link-id'] = 1;

   $unsub_link = $confirm_link = '';
   $domain = !empty($data_values['domain']) ? $data_values['domain'] : Helper::getAppURL();
   if(!empty($contact->id)) {
    $confirm_link = $domain . '/contact/confirm/' . base64_encode($contact->id);
    $unsub_link = $domain . '/contact/unsub/' . base64_encode($contact->id)."/{$campaign_id}/{$type}";
    $unsub_link_confirm = $domain . '/contact/do-unsub/' . base64_encode($contact->id)."/{$campaign_id}/{$type}";
  }

  $system_variables_shortcodes_values = [
    $unsub_link,
    $unsub_link_confirm,
    $list_id,
    $list_name,
    $sender_name,
    $sender_email,
    $receiver_email,
    $todays_date,
    $message_id,
    $contact_id,
  ];

  $data = str_replace($system_variables_shortcodes, $system_variables_shortcodes_values, $data);
  return $data;
}

  /**
   * Retrun strintg after replace the custom fields shortcodes
  */
  public static function replaceCustomFields($data, $contact_custom_fields)
  {
    //$custom_fields = \DB::table('custom_fields')->pluck('tag', 'id');
    $custom_fields = \DB::table('custom_fields')->select('id', 'tag', 'default')->get();

    foreach ($custom_fields as $custom_field) {
      $shortcode = '[#'.$custom_field->tag.'#]'; // custom_field shortcode [#tag#]
      $word = $custom_field->default;
      foreach($contact_custom_fields as $conact_custom_field) {
        if($custom_field->tag == $conact_custom_field->tag) {
          $word = $conact_custom_field->pivot->data;
        }
      }
      $data = str_replace($shortcode, $word, $data);
    }
    return $data;
  }

  /**
   * Retrun strintg after replace the spintags shortcodes
  */
  public static function replaceSpintags($data)
  {
    $spintags = \DB::table('spintags')->pluck('values', 'tag');
    foreach ($spintags as $tag => $values) {
      $shortcode = '[%'.$tag.'%]'; // spintag shortcode [%tag%]
      $words = Helper::splitLineBreakWithComma($values);
      $word = $words[array_rand($words, 1)]; // pick one random word
      $data = str_replace($shortcode, $word, $data);
    }
    return $data;
  }

  /**
   *  Return string after extrat from start and ending values
  */
  public static function extractString($string, $start, $end)
  {
    $start_pos  = strrpos($string , $start)  + strlen($start);
    $end_pos = strpos($string , $end, $start_pos);
    $length = $end_pos - $start_pos + 1;
    return trim(substr($string, $start_pos, $length));
  }

  public static function getRelayzoRef($html) 
  {
    if (preg_match('/rz-ref-(.*?)-rz-ref/', $html, $matches)) {
        return $matches[1]; // Extracted code
    }
    return null; // Return null if not found
  }
  public static function getMailRef($html)
  {
      // Ensure the HTML is properly encoded
      $html = mb_convert_encoding($html, 'HTML-ENTITIES', 'UTF-8');

      // Suppress warnings due to malformed HTML
      libxml_use_internal_errors(true);

      $doc = new \DOMDocument('1.0', 'UTF-8');
      $doc->loadHTML($html);

      libxml_clear_errors();

      $xpath = new \DOMXPath($doc);
      $element = $xpath->query('//*[@id="rz-mail-ref"]')->item(0);

      return $element ? $element->getAttribute('data-value') : false;
  }

  // get data as send for tracking email ref
  public static function toEamil_Section($RZ_type, $this_app_id, $status=null)
  {
      try {
        $stat_log_id = explode('-', $RZ_type)[1];
      } catch(\Exception $e) {
        $stat_log_id = 0;
      }

      try {
        $app_id = explode('-', $RZ_type)[2];
      } catch(\Exception $e) {  }

      if(empty($app_id)) $app_id = $this_app_id;

      $section = 'Campaign';
      $to_email = null;
      $stat_id = 0;

      if($stat_log_id) {
        if(stripos($RZ_type, 'campaign') !== false) {
          if(!empty($status)) {
            \App\Models\ScheduleCampaignStatLog::whereId($stat_log_id)->update(['status' => $status]);
          }

          $stat_data = \App\Models\ScheduleCampaignStatLog::whereId($stat_log_id)->select('email', 'schedule_campaign_stat_id')->first();
          if (!empty($stat_data)) {
            $stat_id = $stat_data->schedule_campaign_stat_id;
            $to_email = $stat_data->email;
          }

        } elseif(stripos($RZ_type, 'trigger') !== false) {
          if(!empty($status)) {
            \App\Models\TriggerScheduleStatLog::whereId($stat_log_id)->update(['status' => $status]);
          }

          $stat_data = \App\Models\TriggerScheduleStatLog::whereId($stat_log_id)->select('email', 'trigger_schedule_stat_id')->first();
          if (!empty($stat_data)) {
            $stat_id = $stat_data->trigger_schedule_stat_id;
            $to_email = $stat_data->email;
            $section = 'Trigger'; // trigger
          }

        } elseif(stripos($RZ_type, 'drip') !== false) {
          if(!empty($status)) {
            \App\Models\DripScheduleStatLog::whereId($stat_log_id)->update(['status' => $status]);
          }

          $stat_data = \App\Models\DripScheduleStatLog::whereId($stat_log_id)->select('email', 'drip_schedule_stat_id')->first();
          if (!empty($stat_data)) {
            $stat_id = $stat_data->drip_schedule_stat_id;
            $to_email = $stat_data->email;
            $section = 'Drip';
          }

        } elseif(stripos($RZ_type, 'splittest') !== false) {
          if(!empty($status)) {
            \App\Models\SplitTestStatLog::whereId($stat_log_id)->update(['status' => $status]);
          }

          $stat_data = \App\Models\SplitTestStatLog::whereId($stat_log_id)->select('email', 'split_test_stat_id')->first();
          if (!empty($stat_data)) {
            $stat_id = $stat_data->split_test_stat_id;
            $to_email = $stat_data->email;
            $section = 'SplitTest';
          }
        }
      }

      return [
        $app_id,
        $stat_log_id,
        $stat_id,
        $to_email,
        $section
      ];
  }

  /**
   * Retrun string with base64 encoding
  */
  public static function base64url_encode($string)
  {
    return quoted_printable_encode(str_replace(array('/'), array('¬'), base64_encode($string)));
  }

  /**
   * Retrun string with base64 decoding
  */
  public static function base64url_decode($string)
  {
    return base64_decode(str_replace(array('¬'), array('/'), quoted_printable_decode($string)));
  }

  /**
   * Retrun string after extract contenct from body tag
  */
  public static function extractHtmlTagContents($tag, $html)
  {
    if (preg_match("~<body[^>]*>(.*?)</body>~si", $html, $tag_data)) {
      return $tag_data[1];
    }
  }

  /**
   * Get client IP
  */
  public static function getClientIP()
  {
    foreach (array('HTTP_CLIENT_IP', 'HTTP_X_FORWARDED_FOR', 'HTTP_X_FORWARDED', 'HTTP_X_CLUSTER_CLIENT_IP', 'HTTP_FORWARDED_FOR', 'HTTP_FORWARDED', 'REMOTE_ADDR') as $key){
      if (array_key_exists($key, $_SERVER) === true){
        foreach (explode(',', $_SERVER[$key]) as $ip){
            $ip = trim($ip); // just to be safe
            if (filter_var($ip, FILTER_VALIDATE_IP) !== false){
              return $ip;
            }
          }
        }
      }
    }

  /**
   * Get geographical detail to an IP
  */
  public static function getGeoInfo($ip)
  {
    try{
      $databaseFile = config('custom.path_maxmind_geo_db');
      $reader = new \MaxMind\Db\Reader($databaseFile);
      $maxmind_ip_info = $reader->get($ip);
      $language = 'en';
      $ip_info['country'] = !empty($maxmind_ip_info['country']['names'][$language]) ? $maxmind_ip_info['country']['names'][$language] : null;
      $ip_info['country_code'] = !empty($maxmind_ip_info['country']['iso_code']) ? $maxmind_ip_info['country']['iso_code'] : null;
      $ip_info['zipcode'] = !empty($maxmind_ip_info['postal']['code']) ? $maxmind_ip_info['postal']['code'] : null;

      $ip_info['city'] = !empty($maxmind_ip_info['city']['names'][$language]) ? $maxmind_ip_info['city']['names'][$language] : null;

      if(empty($ip_info['city'])) {
        $ip_info['city'] =  !empty($maxmind_ip_info['subdivisions'][0]['names'][$language]) ? $maxmind_ip_info['subdivisions'][0]['names'][$language] : null;
      }

      $reader->close();
      return $ip_info;
    } catch(\Exception $e) {}

  }

  /**
   * Get cron command
  */
  public static function getCronCommand()
  {
    // Get PHP Path
    try {
      $php_path = null;
      if (function_exists('exec'))
        $php_path = exec("which php");

      if(empty($php_path)) {
        $php_path =  "/usr/bin/php";
      }
    } catch (\Exception $e) {
      $php_path =  "/usr/bin/php";
    }
    return "* * * * * ".$php_path .' '.base_path().DIRECTORY_SEPARATOR."artisan schedule:run >/dev/null 2>&1";
  }

  /**
   * Get cron last executed minutes
  */
  public static function getCronLatExecutedMinutes()
  {
    // Get cron last executed minutes
    try{
      $settings_attributes = json_decode(\DB::table('settings')->whereId(config('custom.app_id'))->value('attributes'), true);
      $cron_timestamp = $settings_attributes['cron_timestamp'];
      $cron_last_executed  = \Carbon\Carbon::parse($cron_timestamp)->diffInMinutes(\Carbon\Carbon::now());
    } catch (\Exception $e) {
      $cron_last_executed = 0;
    }
    return $cron_last_executed;
  }


  /**
   * App verification
   * WARNING!!! Avoid to make any changes in it.
  */
  public static function verifyLicense($data)
  {
    $url = config('custom.relayzo_verify').http_build_query($data);
    return Helper::getUrl($url);
  }


  /**
   * CURL GET either with http_code if ture then return the http code like 200, 301 etc
  */
  /*public static function getUrl($url, $http_code=false)
  {
    $ch = curl_init();
    curl_setopt_array(
      $ch, array(
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_SSL_VERIFYHOST => false,
        CURLOPT_SSL_VERIFYPEER => false
      )
    );
    $result = curl_exec($ch);
    if($http_code) {
      $result  = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    }
    curl_close($ch);
    return $result;
  }*/

  public static function getUrl($url, $http_code = false)
{
    // Use cURL if available
    if (function_exists('curl_init')) {
        $ch = curl_init();
        curl_setopt_array($ch, [
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_SSL_VERIFYHOST => 0, // 0 disables host verification
            CURLOPT_SSL_VERIFYPEER => false, // false disables peer verification
        ]);
        $result = curl_exec($ch);
        
        // Log or handle any cURL errors
        if (curl_errno($ch)) {
            error_log("cURL error: " . curl_error($ch));
        }
        
        if ($http_code) {
            $result = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        }
        
        curl_close($ch);
        return $result;
    }
    // Fallback to file_get_contents if allow_url_fopen is enabled
    elseif (ini_get('allow_url_fopen')) {
        // Create a stream context to ignore SSL verification similar to cURL settings
        $context = stream_context_create([
            'ssl' => [
                'verify_peer'      => false,
                'verify_peer_name' => false,
            ],
        ]);
        $result = file_get_contents($url, false, $context);
        
        // If HTTP code is requested, extract it from $http_response_header
        if ($http_code) {
            if (isset($http_response_header) && is_array($http_response_header)) {
                // The first element is usually something like: "HTTP/1.1 200 OK"
                $parts = explode(' ', $http_response_header[0]);
                $result = (isset($parts[1])) ? (int)$parts[1] : 0;
            } else {
                $result = 0;
            }
        }
        
        return $result;
    }
    // Neither cURL nor allow_url_fopen is available
    else {
        error_log("Neither cURL nor allow_url_fopen is available.");
        return false;
    }
}


  /**
   * Send more than one get requests at once
  */
  public static function parallelRequests($urls = [])
  {
    // Create the multiple cURL handle
    $mh = curl_multi_init();
    foreach($urls as $ch => $url) {
      // Create cURL resources\
      $$ch = curl_init();
      curl_setopt($$ch, CURLOPT_URL, $url);
      curl_setopt($$ch, CURLOPT_HEADER, 0);
      curl_setopt($$ch, CURLOPT_RETURNTRANSFER, true);
      curl_setopt($$ch, CURLOPT_SSL_VERIFYHOST, false);
      curl_setopt($$ch, CURLOPT_SSL_VERIFYPEER, false);

      // Add into handles
      curl_multi_add_handle($mh, $$ch);
    }

    //execute the multi handle
    do {
      $status = curl_multi_exec($mh, $active);
      if ($active) {
        curl_multi_select($mh);
      }
    } while ($active && $status == CURLM_OK);

    //close the handles
    foreach($urls as $ch => $url) {
      curl_multi_remove_handle($mh, $$ch);
    }
    curl_multi_close($mh);
  }

  /**
   * Send more than one get requests at once
  */
  public static function apiReturn($status, $data)
  {
    return response()->json(['status' => $status, 'response' => $data]);
  }

  /**
   * Convrt links and images links for tracking clicks
  */
  public static function convertLinksForClickTracking($id, $tracking_domain, $content, $app_url, $link_param)
  {
    //link_param can be;  d = drip; af = auto followup
    $track_click = $tracking_domain.$link_param.base64_encode($id);
    try {
      $dom = new \DOMDocument('1.0', 'UTF-8');
      libxml_use_internal_errors(true);
      $dom->loadHTML('<?xml encoding="UTF-8">' . $content);
      libxml_use_internal_errors(false);

      foreach($dom->getElementsByTagName('a') as $a) {
        $href = $a->getAttribute('href');
        $href = $track_click."/". Helper::base64url_encode($href);
        $a->setAttribute('href', $href);
      }

      $app_url_without_protocol = parse_url($app_url, PHP_URL_HOST);
      // Update images sources as well
      foreach($dom->getElementsByTagName('img') as $img) {
        $src = $img->getAttribute('src');
        $url_img_src = parse_url($src, PHP_URL_HOST);
        if($url_img_src == $app_url_without_protocol) {
          $src = str_replace($url_img_src, parse_url($tracking_domain, PHP_URL_HOST), $src);
          $img->setAttribute('src', $src );
        }
      }

      $content = $dom->saveHTML(); 
    } catch (\Exception $e) {
      \Log::error('convertLinksForClickTracking => '.$e->getMessage());
    }
    return $content;
  }

  /**
   * Check if email in the suppression
   * return bollean true/false
  */
  public static function isSuppressed($email, $app_id)
  {
    $is_suppressed = \DB::table('suppressions')
    ->where('app_id', $app_id)
    ->whereEmail($email)
    ->exists();
    if($is_suppressed) return true;

    // Suppress Domain data
    $suppression_domains = \DB::table('suppressions')
    ->where('app_id', $app_id)
    ->where('email', 'LIKE', '@%')
    ->get();
    foreach ($suppression_domains as $data) {
      if (stripos($email, $data->email) !== false) {
        return true;
      }
    }

    return false;
  }

  /**
   * Return max file size for uploaded file
  */
  public static function getMaxFileSize($only_value=false, $db=false)
  {
    try {
      $upload_max_filesize = ini_get('upload_max_filesize');
      if($only_value) {
        if($db) {
          return Helper::getMaxFileSizeDB();
        } else {
          return str_replace('M','', $upload_max_filesize);
        }
      }
      if($db) {
        return '<i>'.__('app.max_file_size') . ': <b>' . Helper::getMaxFileSizeDB().'M</b></i>';
      } else {
        return '<i>'.__('app.max_file_size') . ': <b>' . $upload_max_filesize.'</b></i>';
      }
      
    } catch(\Exception $e) {
      // nothing
    }
  }

  /**
   * Return max file size for uploaded file from DB
  */
  public static function getMaxFileSizeDB()
  {
    $settings = \DB::table('settings')->whereId(config('custom.app_id'))->first();
    $attributes = json_decode($settings->attributes);
    $max_file_size = !empty($attributes->max_file_size) ? $attributes->max_file_size : Helper::getMaxFileSize($only_value=true);
    return $max_file_size; // convert into MB
  }

  /**
   * Return max file size for uploaded file into MB
  */
  public static function getMaxFileSizeMB()
  {
    return Helper::getMaxFileSize($only_value=true, $db=true)*1024;
  }

  /**
   * Verify Email and return response
  */
  public static function verifyEmail($data, $encrypt=false)
  {
    if($data['type'] != 'relayzo')
      $api_key = $encrypt ? \Crypt::decrypt($data['api_key']) : $data['api_key'];

    switch($data['type']) {
      
      case 'relayzo':
      try {
         $result = \App\Services\RelayzoEmailVerificationService::verifyEmail($data['email'], Helper::getAppURL($without_protocol=true));
         $response = [
          'success' => $result['status'],
          'message' => json_encode([
            'Detail' => $result['detail'],
            'Syntax Valid' => $result['syntax_valid'],
            'MX Valid' => $result['mx_valid'],
            'Disposable' => $result['is_disposable'],
            'Role Account' => $result['is_role_account'],
         //   'inbox_exists' => $result['inbox_exists']
          ]),
          'increment' => true
        ];
        //return response()->json($result);
      } catch (\Exception $e) {
        $response = [
          'success' => false,
          'message' => $e->getMessage(),
          'increment' => false
        ];
      }
      break;

      case 'kickbox':
      try {
          $client = new \GuzzleHttp\Client();
          $rawResponse = $client->request('GET', 'https://api.kickbox.com/v2/verify', [
              'query' => [
                  'apikey' => $api_key,
                  'email' => $data['email']
              ]
          ]);

          $decoded = json_decode($rawResponse->getBody(), true);

          $response = [
              'success' => $decoded['success'] ?? false,
              'message' => ($decoded['result'] ?? 'Unknown') . ', ' . ($decoded['reason'] ?? 'No reason'),
              'increment' => true
          ];
      } catch (\Exception $e) {
          $response = [
              'success' => false,
              'message' => $e->getMessage(),
              'increment' => false
          ];
      }
      break;

      case 'neverbounce':
      try {
          $client = new \GuzzleHttp\Client();
           $response = $client->request('GET', 'https://apps.emaillistverify.com/api/verifyEmail', [
                'query' => [
                    'secret' => $api_key,  // Your API key (secret)
                    'email' => $data['email']  // Email to be verified
                ]
            ]);

          $responseData = json_decode($response, true);
          $response = [
              'success' => $responseData['body']['success'],
              'message' => $responseData['body']['result'] . ', ' . $responseData['body']['reason'],
              'increment' => true
          ];
      } catch (\Exception $e) {
          $response = [
              'success' => false,
              'message' => $e->getMessage(),
              'increment' => false
          ];
      }
      break;

      case 'sendgrid':
      try {
        $client = new \GuzzleHttp\Client(['base_uri' => 'https://api.sendgrid.com/v3/validations/']);
        $headers = [
          'Authorization' => 'Bearer ' . $api_key,
          'Accept'        => 'application/json',
        ];

        $response = $client->request('POST', 'email', [
          'headers' => $headers,
          'json' => [
            'email' => $data['email'],
            'source' => 'signup'
           ]
        ])->getBody()->getContents();

        $response = json_decode($response, true);

        $response = [
          'success' => $response['result']['checks']['domain']['has_mx_or_a_record'],
          'message' => $response['result']['verdict'],
          'increment' => true
        ];
      } catch (\Exception $e) {
        $response = [
          'success' => false,
          'message' => $e->getMessage(),
          'increment' => false
        ];
      }
      break;

      case 'mailgun':
      try {
        $client = new \GuzzleHttp\Client();
        $response = $client->request('GET', 'https://api.mailgun.net/v4/address/validate', [
          'auth' => ['api', $api_key],
          'form_params' => ['address' => "{$data['email']}"]
        ]);
        $response = json_decode($response, true);
        $status = $response['result'] == 'deliverable' ? 1: 0;
        $response = [
          'success' => $status,
          'message' => "{$response['result']} ({$response['reason']})",
          'increment' => true
        ];
      } catch (\Exception $e) {
        $response = [
          'success' => false,
          'message' => $e->getMessage(),
          'increment' => false
        ];
      }
      break;

      case 'bulkemailchecker':
      try {
        $response = Helper::getUrl("https://api-v4.bulkemailchecker.com/?key={$api_key}&email=".$data['email']);
        $response = json_decode($response, true);
        $status = !empty($response['status']) && $response['status'] == 'passed' ? 1: 0;
        $response['result'] = !empty($response['error']) ? $response['error'] : $response['email'] ?? '';
        $response = [
          'success' => $status,
          'message' => "{$response['result']}",
          'increment' => true
        ];
      } catch (\Exception $e) {
        $response = [
          'success' => false,
          'message' => $e->getMessage(),
          'increment' => false
        ];
      }
      break;
    }

   // return response()->json($response);
    return $response;
  } // end Switch

  /**
  * List of domins that needs to check for blacklisted
  */
  public static function DNSBLLookup($input, $isDomain = false)
  {
      $dnsbls = [
        "zen.spamhaus.org",
        "bl.spamcop.net",
        "b.barracudacentral.org",
        "dnsbl.sorbs.net",
        "spam.spamrats.com",
        "multi.surbl.org",
        "sbl.spamhaus.org",
        "xbl.spamhaus.org",
        "pbl.spamhaus.org",
        "dnsbl.dronebl.org",
        "psbl.surriel.com",
        "bl.mailspike.net",
        "rbl.interserver.net",
        "cbl.abuseat.org",
        "ubl.unsubscore.com",
        "dnsbl.tornevall.org",
        "truncate.gbudb.net",
        "hostkarma.junkemailfilter.com",
        "backscatter.spameatingmonkey.net",
        "bl.spameatingmonkey.net",
        "bl.rbl.scrolloutf1.com",
        "rbl.abuse.ro",
        "dnsbl.justspam.org",
        "dnsbl.kempt.net",
        "bl.drmx.org",
        "all.spamrats.com",
        "black.mail.abusix.zone",
        "dnsrbl.swinog.ch",
        "ivmURI.ivmSIP.com",
        "ivmSIP.invaluement.com",
        "ivmSIP/24.invaluement.com",
        "dnsbl.zapbl.net",
        "spam.dnsbl.anonmails.de",
        "spam.pedantic.org",
        "0spamurl.fusionzero.com",
        "bl.fmb.la",
        "black.uribl.com",
        "blacklist.netcore.co.in",
        "bsb.spamlookup.net",
        "dbl.suomispam.net",
        "dbl.tiopan.com",
        "dblack.mail.abusix.zone",
        "dnsbl.spfbl.net",
        "all.s5h.net",
        "dyna.spamrats.com",
        "access.redhawk.org",
        "backscatter.spameatingmonkey.net",
        "bb.barracudacentral.org",
        "bl.nosolicitado.org",
        "bl.scientificspam.net",
        "bl.worst.nosolicitado.org",
        "black.junkemailfilter.com",
        "cart00ney.surriel.com",
        "dnsbl-1.uceprotect.net",
        "dnsbl-2.uceprotect.net",
        "dnsbl-3.uceprotect.net",
        "dnsbl.net.ua",
        "exploit.mail.abusix.zone",
        "fnrbl.fast.net",
        "ips.backscatterer.org",
        "mail-abuse.blacklist.jippg.org",
        "mail-abuse.com",
        "netscan.rbl.blockedservers.com",
        "noptr.spamrats.com",
        "NordSpam",
        "rbl.blockedservers.com",
        "rbl.dns-servicios.com",
        "rbl2.triumf.ca",
        "rep.mailspike.net",
        "spam.rbl.blockedservers.com",
        "spamlist.or.kr",
        "spamrbl.imp.ch",
        "spamsources.fabel.dk",
        "talosintelligence.com",
        "torexit.dan.me.uk",
        "z.mailspike.net"
    ];

    if ($isDomain) {
        $resolvedIp = gethostbyname($input);
        if ($resolvedIp === $input || !filter_var($resolvedIp, FILTER_VALIDATE_IP)) {
            //return ["error" => "Invalid domain or unable to resolve IP"];
        }
    } else {
        $resolvedIp = $input;
    }

    // Reverse IP for DNSBL lookup
    $reverseIp = implode(".", array_reverse(explode(".", $resolvedIp)));

    $listed = [];
    $counts = 0;
    foreach ($dnsbls as $blacklist) {
        $query = "$reverseIp.$blacklist";
        if (checkdnsrr($query . ".", "A")) {
            $listed[$blacklist] = 'Yes';
            $counts++;
        } else {
            $listed[$blacklist] = 'No';
        }
    }

    $listed['counts'] = $counts;
    return $listed;
  }



  /**
   * Check IPs / Domains Lookup
  */
  public static function checkIPsDomainsLookup()
  {
    // First need to empty the table otherwise duplicate entries
    \DB::table('blacklisteds')->truncate();

    // Check Smtps
    $sending_servers = \App\Models\SendingServer::whereStatus('Active')
    ->whereType('smtp')
    ->get();

    foreach($sending_servers as $sending_server) {
      $host = json_decode($sending_server->sending_attributes, true)['host'];
      if(filter_var($host, FILTER_VALIDATE_IP)) {
        $result = Helper::DNSBLLookup($host);
        $ip_domain = 'ip';
      } else {
        $result = Helper::DNSBLLookup($host, $domain=true);
        $ip_domain = 'domain';
      }

      // Get counts
      $counts = array_pop($result);

      // Save data
      \DB::table('blacklisteds')->insert([
        'name' => $host,
        'ip_domain' => $ip_domain,
        'counts' => $counts,
        'detail' => json_encode($result),
        'app_id' => $sending_server->app_id,
        'user_id' => $sending_server->user_id,
        'created_at' => \Carbon\Carbon::now()
      ]);
    }


    // Get App URL, Check the application URL also
    $host =  Helper::getAppURL($without_protocol=true);
    $result = Helper::DNSBLLookup($host, $domain=true);

    // Get counts
    $counts = array_pop($result);

    // Save data
    \DB::table('blacklisteds')->insert([
      'name' => $host,
      'ip_domain' => 'domain',
      'counts' => $counts,
      'detail' => json_encode($result),
      'app_id' => $sending_server->app_id,
      'user_id' => $sending_server->user_id,
      'created_at' => \Carbon\Carbon::now()
    ]);
    

    // Check Sending Domains
    $sending_domains = \App\Models\SendingDomain::whereIsActive(true)->get();

    foreach($sending_domains as $domain) {
      $host = $domain->domain;
      if(filter_var($host, FILTER_VALIDATE_IP)) {
        $result = Helper::DNSBLLookup($host);
        $ip_domain = 'ip';
      } else {
        $result = Helper::DNSBLLookup($host, true);
        $ip_domain = 'domain';
      }

      // Get counts
      $counts = array_pop($result);

      // Save data
      \DB::table('blacklisteds')->insert([
        'name' => $host,
        'ip_domain' => $ip_domain,
        'counts' => $counts,
        'detail' => json_encode($result),
        'app_id' => $domain->app_id,
        'user_id' => $domain->user_id,
        'created_at' => \Carbon\Carbon::now()
      ]);
    }
  }

  /*
   * Get the allowed limit to client
  */
  public static function getClientAttributeValue($app_id, $section)
  {
    // Need to fetch first recored, it would be client always
    $package_id = \App\Models\User::whereAppId($app_id)->orderBy('id')->value('package_id');
    if(!empty($package_id)) {
      $attributes = json_decode(\App\Models\Package::whereId($package_id)->orderBy('id')->value('attributes'), true);
    } else {
      $attributes[$section] = null;
    }
    
    return $attributes[$section] ?? null;
  }

  /*
   * Return true/false according to the limit to a client
  */
  public static function allowedLimit($app_id, $section, $table)
  {
    // If Superadmin/Superadmin users
    if($app_id == config('custom.app_id')) return true;

    $allowed_limit = Helper::getClientAttributeValue($app_id, $section);
    // Client limit is unlimited
    if($allowed_limit == -1) return true;

    $exist = \DB::table($table)->whereAppId($app_id)->count();
    return $allowed_limit > $exist ? true : false;
  }

  /*
   * Return value either unlimited to display
  */
  public static function displayValueOrUnlimited($app_id, $section)
  {
    $allowed_limit = Helper::getClientAttributeValue($app_id, $section);
    return $allowed_limit == -1 ? "&infin;" : $allowed_limit;
  }

  /*
   * Get table, stat_id, email for campaign, drip, and auto-followup against message_id
  */
  public static function statMessageDetail($message_id, $email=null)
  {
    
    $table_app_id = 'schedule_campaign_stats';
    $table = 'schedule_campaign_stat_logs';
    $section = 'Campaign';

    // In Sparkpost we are not getting same message-id so getting the values via email
    if(!empty($email)) {
      $stat = \DB::table($table)
      ->whereEmail($email)
      ->select('id', 'email', 'sending_server', 'schedule_campaign_stat_id as schedule_id')
      ->orderBy('id', 'DESC')
      ->first();
    } else {
      $message_id = trim(trim($message_id), '<>');
      $stat = \DB::table($table)
      ->whereMessageId($message_id)
      ->select('id', 'email', 'sending_server', 'schedule_campaign_stat_id as schedule_id')
      ->first();

      if(empty($stat->id)) {
        $table_app_id = 'trigger_schedule_stats';
        $table = 'trigger_schedule_stat_logs';
        $section = 'Trigger';
        $stat = \DB::table($table)
          ->whereMessageId($message_id)
          ->select('id', 'email', 'sending_server', 'trigger_schedule_stat_id as schedule_id')
          ->first();
      }
    }
    

    // Get App ID
    if(!empty($stat->id)) {
      $app_id = \DB::table($table_app_id)->whereId($stat->schedule_id)->value('app_id');
    }

    return [
      $table ?? null,
      $stat->id ?? null,
      $stat->email ?? null,
      $stat->sending_server ?? null,
      $section ?? null,
      $app_id ?? null,
      $stat->schedule_id ?? null,
    ];
  }

  /*
   * Save bounce data for campaing, drips, auto-follwups
  */
  public static function saveBounce($stat_id, $to_email, $stat_log_id, $section, $code, $type, $short_detail, $full_detail, $app_id)
  {
    // Insert bounce data if not already exist
    if(!empty($to_email) && !\App\Models\GlobalBounce::whereScheduleCampaignStatLogId($stat_log_id)->whereSection($section)->exists()) {
      try {
        $bounce_data = [
          'stat_id' => $stat_id,
          'schedule_campaign_stat_log_id' => $stat_log_id,
          'section' => $section,
          'email'  => $to_email,
          'code'   => $code,
          'type'   => $type,
          'detail' => json_encode(['short_detail' => $short_detail, 'full_detail' => $full_detail]),
          'app_id' => $app_id,
          'created_at' => \Carbon\Carbon::now(),
        ];
        \App\Models\GlobalBounce::create($bounce_data);

        \App\Models\Contact::whereEmail($to_email)->update([
          'is_bounced' => true
        ]);

      } catch(\Exception $e) {
        $error = $e->getMessage();
        \Log::error("save-bounces-{$section} => ".$error);
        // nothing to do
      }
    }
  }

  /*
   * Save spam data for campaing, drips, auto-follwups
  */
  public static function saveSpam($stat_id, $to_email, $stat_log_id, $section, $full_detail, $app_id)
  { 
    // Insert spam data if not already exist
    if(!empty($to_email) && !\App\Models\GlobalSpams::where('schedule_campaign_stat_log_id', $stat_log_id)->where('section', $section)->exists()) {
      try {
        $spam_data = [
          'stat_id' => $stat_id,
          'schedule_campaign_stat_log_id' => $stat_log_id,
          'section' => $section,
          'email'  => $to_email,
          'detail' => json_encode(['full_detail' => $full_detail]),
          'app_id' => $app_id,
          'created_at' => \Carbon\Carbon::now(),
        ];
        \App\Models\GlobalSpams::create($spam_data);
      } catch(\Exception $e) {
        $error = $e->getMessage();
       \Log::error("save-spam-{$section} => ".$error);
        // nothing to do
      }
    }
  }

  /*
   * Save replies data for campaing, drips, auto-follwups
  */
  public static function saveReplies($stat_id, $to_email, $stat_log_id, $section, $full_detail, $app_id)
  { 
    // Insert reply data if not already exist
    if(!empty($to_email) && !\App\Models\Replies::where('schedule_campaign_stat_log_id', $stat_log_id)->where('section', $section)->exists()) {
      try {
        $reply_data = [
          'stat_id' => $stat_id,
          'schedule_campaign_stat_log_id' => $stat_log_id,
          'section' => $section,
          'email'  => $to_email,
          'detail' => json_encode(['full_detail' => $full_detail]),
          'app_id' => $app_id,
          'created_at' => \Carbon\Carbon::now(),
        ];
        \App\Models\Replies::create($reply_data);
      } catch(\Exception $e) {
       $error = $e->getMessage();
       \Log::error("save-reply-{$section} => ".$error);
        // nothing to do
      }
    }
  }

  /*
   * Save get broadcasts links
  */
  public static function getBroadcastLinks($broadcast_ids)
  {
    $broadcasts = \App\Models\Broadcast::whereIn('id', $broadcast_ids)->distinct()->get();
    $links = [];
    foreach($broadcasts as $broadcast) {
      try {
        $dom = new \DOMDocument('1.0', 'UTF-8');
        libxml_use_internal_errors(true);
        $dom->loadHTML('<?xml encoding="UTF-8">' . $broadcast->content_html);
        libxml_use_internal_errors(false);

        foreach($dom->getElementsByTagName('a') as $a) {
          $href = $a->getAttribute('href');
          if(stripos($href, '[$unsub-link$]') === false)
            array_push($links, $href);
        } 
      } catch (\Exception $e) {
        \Log::error('getBroadcastLinks => '.$e->getMessage());
      }
    }
    return $links;
  }

  // Replace XSS tags
  public static function XSSReplaceTags($input)
  {

    return $input;
    // some issue for some htmls of campaings
    /*return str_ireplace(['<script', '</script>', 'onmouseover', 'onmouseout', 'onmouseup', 'onload', 'onclick', 'equiv', 'alert', 'javascript','javascript','iframe', '"="', '""=""', '" ""', '""'], ['', '', '', '', '', '', '', '', '', '', '', '', '"', '"', '"', '"'], $input);*/
  }

  // Encode save string
  public static function encodeString($input)
  {
    return htmlentities($input, ENT_QUOTES);
  }

  // Decode string
  public static function decodeString($input)
  {
    return html_entity_decode($input, ENT_QUOTES);
  }

  /**
   * Return ture/false after verify domain DKIM
  */
  public static function verifyDKIM($sending_domain)
  {
    // Should be set to unverified before verifcation
    \App\Models\SendingDomain::whereId($sending_domain->id)->update(['is_verified_key' => false]);

    $key = false;
    try {
      if(Helper::isSubdomain($sending_domain->domain)) {
        $domain = $sending_domain->host_dkim.'.'.$sending_domain->domain;
        $domain = preg_replace('/(\b\w+)(\.\1)+/', '$1', $domain);
      } else {
        $domain = $sending_domain->host_dkim.'.'.$sending_domain->domain;
      }
      $dkim_values = dns_get_record($domain, DNS_TXT);
    } catch (\Exception $e) {
      $dkim_values = null;
    }

    if (!empty($dkim_values)) {
      foreach($dkim_values as $dns_txt) {
        // public key verification
        $public_key = str_replace(['-----BEGINPUBLICKEY-----', '-----ENDPUBLICKEY-----'], ['', ''], $sending_domain->public_key);
        if(strpos($dns_txt['txt'], $public_key) !== false) {
          \App\Models\SendingDomain::whereId($sending_domain->id)->update(['is_verified_key' => true]);
          $key = true;
        }
      }
    }
    return $key;
  }

  /**
   * Return ture/false after verify domain SPF
  */
  public static function verifySPF($sending_domain)
  {
    // Should be set to unverified before verifcation
    \App\Models\SendingDomain::whereId($sending_domain->id)->update(['is_verified_spf' => false]);

    $spf = false;
    $spf_values = Helper::getSPFRecordForDomain($sending_domain->host_spf);

    if (!empty($spf_values)) {
      foreach($spf_values as $dns_txt) {
        // spf verification
        if(!empty($dns_txt) && $dns_txt == $sending_domain->value_spf) {
          \App\Models\SendingDomain::whereId($sending_domain->id)->update(['is_verified_spf' => true]);
          $spf = true;
        } elseif(!empty($dns_txt['txt']) && $dns_txt['txt'] == $sending_domain->value_spf) {
          \App\Models\SendingDomain::whereId($sending_domain->id)->update(['is_verified_spf' => true]);
          $spf = true;
        }
      }
    }
    return $spf;
  }

  /**
   * Return ture/false after verify domain DMARC
  */
  public static function verifyDMARC($sending_domain)
  {
    // Should be set to unverified before verifcation
    \App\Models\SendingDomain::whereId($sending_domain->id)->update(['is_verified_dmarc' => false]);

    $dmarc = false;
    $dmarc_values = dns_get_record($sending_domain->host_dmarc, DNS_TXT);

    if (!empty($dmarc_values)) {
      foreach($dmarc_values as $dns_txt) {
        // dmarc verification
        if($dns_txt['txt'] == $sending_domain->value_dmarc || 
        strpos($dns_txt['txt'], "v=DMARC1;p=none;") !== false || strpos($dns_txt['txt'], "v=DMARC1;p=quarantine;") !== false || strpos($dns_txt['txt'], "v=DMARC1;p=reject;") !== false) {
          \App\Models\SendingDomain::whereId($sending_domain->id)->update(['is_verified_dmarc' => true]);
          $dmarc = true;
        }
      }
    }
    return $dmarc;
  }

  /**
   * Return ture/false after verify domain Tracking
  */
  public static function verifyTracking($tracking_domain)
  {
    // Should be set to unverified before verifcation
    \App\Models\TrackingDomain::whereId($tracking_domain->id)->update([ 'is_verified' => false]);

    $tracking = false;
    // cname verification
    $cname_host = $tracking_domain->protocol.$tracking_domain->domain;

    $response = json_decode(Helper::getUrl($cname_host.'/ok'), true);
    if(!empty($response['success']) && $response['success'] == 'success') {
      \App\Models\TrackingDomain::whereId($tracking_domain->id)->update(['is_verified' => true]);
      $tracking = true;
    }

    return $tracking;
  }

    public static function getSPFRecordForDomain($domain)
    {
        $records = dns_get_record($domain, DNS_TXT | DNS_SOA);
        if (false === $records) {
            throw new DNSLookupException;
        }

        $spfRecords = array();
        foreach ($records as $record) {
            if ($record['type'] == 'TXT') {
                $txt = strtolower($record['txt']);
                // An SPF record can be empty (no mechanism)
                if ($txt == 'v=spf1' || stripos($txt, 'v=spf1 ') === 0) {
                    $spfRecords[] = $txt;
                }
            }
        }

        return $spfRecords;
    }

    public static function createZipFile($zip_path, $file_path, $file_name='')
    {
      try {
        $zip = new \ZipArchive;
        if ($zip->open($zip_path, \ZipArchive::CREATE) === TRUE) {
            // Add files to the zip file
            $zip->addFile($file_path, $file_name); // Add file with path and desired name in zip
            $zip->close();
        } else {
            return response()->json(['error' => 'Unable to create zip file'], 500);
        }
      } catch(\Exception $e) {}
    }

    public static function createZipFolder($zipPath, $sourceFolder, $excludes = [])
    {
        $zip = new \ZipArchive;

        if ($zip->open($zipPath, \ZipArchive::CREATE | \ZipArchive::OVERWRITE) === TRUE) {

            $files = new \RecursiveIteratorIterator(
                new \RecursiveDirectoryIterator($sourceFolder, \FilesystemIterator::SKIP_DOTS),
                \RecursiveIteratorIterator::SELF_FIRST
            );

            foreach ($files as $file) {
                $filePath = $file->getRealPath();
                $relativePath = substr($filePath, strlen($sourceFolder) + 1);

                // Skip excluded folders/files
                foreach ($excludes as $exclude) {
                    if (strpos($relativePath, $exclude) === 0) {
                        continue 2;
                    }
                }

                if ($file->isDir()) {
                    $zip->addEmptyDir($relativePath);
                } else {
                    $zip->addFile($filePath, $relativePath);
                }
            }

            $zip->close();
        } else {
            return response()->json(['error' => 'Unable to create zip file'], 500);
        }
    }

    public static function checkSpamScore($htmlContent) 
    {
        $spamDetails = [];
        $spamScore = 0;

        // List of spam words with assigned scores
        $spamWords = [
            //High-risk words (Score: 4) - Almost always spam
            'make money' => 4, 'get rich quick' => 4, 'lottery' => 4, 'bitcoin investment' => 4, 
            'earn bitcoin fast' => 4, 'instant crypto profit' => 4, 'guaranteed bitcoin return' => 4, 
            'double your crypto' => 4, 'free ethereum' => 4, 'win big' => 4, 'big cash prize' => 4, 
            'casino' => 4, 'hot deal' => 4, 'millionaire' => 4, 'easy money' => 4, 
            '100% free' => 4, 'free money' => 4, 'no risk' => 4, 'double your income' => 4,
            'you won' => 4, 'cash prize' => 4, 'earn per week' => 4, 'financial freedom' => 4, 
            'urgent payout' => 4, 'no credit check' => 4, 'get paid fast' => 4,

            //Medium-risk words (Score: 3) - Likely spam indicators
            'winner' => 3, 'click here' => 3, 'buy now' => 3, 'limited time' => 3, 'urgent' => 3,
            'money back' => 3, 'congratulations' => 3, 'claim' => 3, 'risk-free' => 3, 
            'instant access' => 3, 'investment' => 3, 'prize' => 3, 'bonus' => 3,
            'you have won' => 3, 'lucky winner' => 3, 'jackpot' => 3, 'exclusive deal' => 3,
            'order now' => 3, 'tech support' => 3, 'your account has been hacked' => 3, 
            'lottery' => 3, 'incredible deal' => 3, 'don’t miss this' => 3, 'call now' => 3,
            'free trial' => 3, 'get started now' => 3, 'new customers only' => 3, 'winning' => 3,

            //Low-risk words (Score: 2) - Could be spam in some cases
            'free' => 2, 'cheap' => 2, 'discount' => 2, 'special promotion' => 2, 
            'guaranteed' => 2, 'password reset' => 2, 'urgent notice' => 2, 
            'confidential information' => 2, 'pharmacy online' => 2, 'male enhancement' => 2,
            'miracle cure' => 2, 'prescription drugs' => 2, 'click below' => 2, 
            'fast shipping' => 2, 'no hidden fees' => 2, 'gift card' => 2,
            'best rates' => 2, 'apply now' => 2, 'exclusive offer' => 2, 'as seen on' => 2,
            'act fast' => 2, 'expires soon' => 2, 'trial offer' => 2, 'get results' => 2,
            'win money' => 2, 'hurry up' => 2, 'special price' => 2,

            //Very low-risk words (Score: 1) - Rarely spam but could be
            'best price' => 1, 'save big money' => 1, 'cash bonus' => 1, 
            'dear customer' => 1, 'bank account' => 1, 'verify your identity' => 1,
            'urgent request' => 1, 'once in a lifetime' => 1, 'this isn’t spam' => 1,
            'increase sales' => 1, 'lowest price' => 1, 'big savings' => 1, 'limited supply' => 1,
            'unlock access' => 1, 'biggest discount' => 1, '100% guaranteed' => 1,
            'don’t delete' => 1, 'urgent reply needed' => 1, 'earn big' => 1,
        ];


        // Suspicious HTML tags with assigned scores
        $htmlTags = [
            'iframe' => 3, 'script' => 3, 'object' => 3, 'form' => 2, 'input' => 2
        ];

        // Check for spam words (case-insensitive)
        foreach ($spamWords as $word => $score) {
            if (stripos($htmlContent, $word) !== false) {
                $spamScore += $score;
                $spamDetails[] = "'$word' (+$score)";
            }
        }

        // Check for spammy HTML tags
        foreach ($htmlTags as $tag => $score) {
            if (stripos($htmlContent, "<$tag") !== false) {
                $spamScore += $score;
                $spamDetails[] = "<$tag> (+$score)";
            }
        }

        // Check for excessive links (potential phishing)
        preg_match_all('/<a\s+href=["\'](.*?)["\']/', $htmlContent, $matches);
        $linkCount = count($matches[1]);
        if ($linkCount > 5) {
            $spamScore += 5;  // Too many links increase spam score
            $spamDetails[] = "($linkCount found) (+5)";
        }

        // Return a detailed breakdown of the spam score
        return [
            'total_spam_score' => $spamScore,
            'details' => $spamDetails
        ];
    } 

    public static function getLaravelLogs($lines = 100) {
        $logFile = storage_path(config('custom.laravel_log_file'));

        if (!\Illuminate\Support\Facades\File::exists($logFile)) {
            return 'Log file does not exist.';
        }

         // Read the entire log file into an array of lines
        $logLines = explode("\n", \Illuminate\Support\Facades\File::get($logFile));

        // Filter only lines with "production.ERROR" and "mail" or "SMTP"
        $filteredLogs = array_filter($logLines, function ($line) {
            return str_contains($line, 'production.ERROR') && 
                   (str_contains($line, 'mail') || str_contains($line, 'SMTP'));
        });

        // Get only the last N lines
        $logs = implode("\n\n\n", array_slice($filteredLogs, -$lines));

        if(empty($logs)) $logs = __('app.no_record_found');

        return htmlspecialchars($logs);
    }

    public static function clearErrorLogs()
    {
        $logFile = storage_path('logs/laravel.log');

        if (\Illuminate\Support\Facades\File::exists($logFile)) {
            \Illuminate\Support\Facades\File::put($logFile, ''); // Clears the file
        }

        return redirect()->route('error.logs')->with('success', __('app.clear_error_logs_successfully'));
    }

    public static function getWeekDays()
    {
      return [        
        'monday'    => 'Monday',
        'tuesday'   => 'Tuesday',
        'wednesday' => 'Wednesday',
        'thursday'  => 'Thursday',
        'friday'    => 'Friday',
        'saturday'  => 'Saturday',
        'sunday'    => 'Sunday',
      ];
    }

    public static function timeOptions($hours=24) 
    {
        $times = [];

        // Loop through 1 to 24 hours and generate the correct AM/PM format
        for ($i = 1; $i <= $hours; $i++) {
            $hour = $i <= 12 ? $i : $i - 12;
            $period = $i < 12 ? 'AM' : 'PM';
            
            // Special case for 24 as 12 AM
            if ($i == 24) {
                $hour = 12;
                $period = 'AM';
            }

            // Add the time to the associative array
            $times[$i] = "$hour $period";
        }

        return $times;
    }

    public static function convertMarkdownBoldToHtml($text) {
        return preg_replace('/\*\*(.*?)\*\*/', '<strong>$1</strong>', $text);
    }

    public static function chatGPT($text)
    {
        $improved = \App\Services\ChatGPTService::improveText($text);
        return [
            'original' => $text,
            'improved' => nl2br(Helper::convertMarkdownBoldToHtml($improved)),
        ];
    }

    public static function chatGPTModles()
    {
      return [
        'gpt-4.1'        => 'gpt-4.1',
        'gpt-4.1-mini'   => 'gpt-4.1-mini',
        'gpt-4.1-nano'   => 'gpt-4.1-nano',
        'gpt-4o'         => 'gpt-4o',         // fallback / legacy if needed
        'gpt-3.5-turbo'  => 'gpt-3.5-turbo',  // still widely used
        'gpt-3.5-turbo-0125' => 'gpt-3.5-turbo-0125',
      ];
    }

    public static function isSubdomain($host) {
      $host = rtrim($host, '.'); // remove trailing dot
      $parts = explode('.', $host);

      return (count($parts) > 2); // true if more than 2 parts
  }

  /**
   * Return content editor action buttons
   */
  public static function contentEditorButtons($content_id = 'content_html', $show_shortcodes = true, $show_template = true, $show_spam_check = true, $show_import_campaign = false, $show_ai_analysis = false)
  {
    $buttons = '<div class="d-flex gap-2 mb-2">';
    
    if($show_shortcodes) {
      $buttons .= '<button type="button" class="btn btn-outline-primary btn-sm" onclick="viewModal(\'modal\', \''.route('shortcodes').'\');" tabindex="-1">
        <i class="bi bi-code me-1"></i>'.__('app.shortcodes').'
      </button>';
    }
    
    if($show_import_campaign) {
      $buttons .= '<button type="button" class="btn btn-outline-primary btn-sm" onclick="viewModal(\'modal\', \''.route('broadcasts.all').'\');" tabindex="-1">
        <i class="bi bi-file-earmark-arrow-down me-1"></i>'.__('app.import_campaign').'
      </button>';
    }
    
    if($show_template) {
      $buttons .= '<button type="button" class="btn btn-outline-primary btn-sm" onclick="viewModal(\'modal\', \''.route('templates.all').'\');" tabindex="-1">
        <i class="bi bi-file-earmark-arrow-down me-1"></i>'.__('app.import_template').'
      </button>';
    }
    
    if($show_spam_check) {
      $buttons .= '<button type="button" class="btn btn-outline-primary btn-sm" onclick="checkSpamScore(\'modal\', \''.route('check.spam.score').'\', CKEDITOR.instances[\''.$content_id.'\'].getData());" tabindex="-1">
        <i class="bi bi-shield-check me-1"></i>'.__('app.check_spam_score').'
      </button>';
    }
    
    if($show_ai_analysis && \Auth::user()->chatgpt_enabled && \App\Http\Helper\Helper::checkPermissions('settings_chatGPT', false)) {
      $buttons .= '<button type="button" class="btn btn-primary1 btn-sm btn-loading" onclick="aiAnalysisCampaign()" tabindex="-1">
        <i class="bi bi-stars me-1"></i>'.__('app.ai_analysis').'
      </button>';
    }
    
    $buttons .= '</div>';
    
    return $buttons;
  }
}