<?php

namespace App\Http\Middleware;

use Auth;
use App;
use Closure;
use App\Models\User;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class SetLocal
{
    /**
     * Handle an incoming request.
     * 
     * This middleware sets the application locale based on the user's language preference
     * and automatically updates the user's direction field (RTL for Arabic, LTR for others).
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        if (Auth::check()) {
            $user = Auth::user();
            $language = !empty($user->language) ? $user->language : 'en';
            
            // Set the locale
            App::setLocale($language);
            
            // Update direction based on language
            $direction = ($language === 'ar') ? 'rtl' : 'ltr';
            
            // Only update if the direction has changed to avoid unnecessary database calls
            if ($user->direction !== $direction) {
                $user->update(['direction' => $direction]);
            }
            
            // Set theme direction in session for frontend JavaScript
            session(['theme_direction' => $direction]);
        } else {
            // If user is not authenticated, set default locale and direction
            App::setLocale('en');
            session(['theme_direction' => 'ltr']);
        }
        
        return $next($request);
    }
}
