<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CreateFblRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true; // Update this if authorization logic is required
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        $fbl = $this->route('fbl');
        return [
            'email' => 'required|email|unique:fbls,email' . ($fbl ? ',' . $fbl->id : ''),
            'host' => 'required',
            'username' => 'required',
            'password' => 'required',
            'port' => 'required|integer'
        ];
    }
}
