<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CreateListRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true; // Update this if authorization logic is required
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        return [
            'name' => 'required',
            'group_id' => 'required|integer',
            'from_email_part1' => 'required',
            'from_email_part2' => 'required',
            'reply_email' => 'required|email'
        ];
    }

    /**
     * Get custom messages for validator errors.
     */
    public function messages(): array
    {
        return [
            'group_id.required' => 'Group is required.',
            'from_email_part1.required' => 'From Email Name is required.',
            'from_email_part2.required' => 'From Email Domain is required.'
        ];
    }
}
