<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CreateReplyServerRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true; // Update this if authorization logic is required
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        $reply_server = $this->route('reply_server');
        return [
            'email' => 'required|email|unique:reply_servers,email' . ($reply_server ? ',' . $reply_server->id : ''),
            'host' => 'required',
            'username' => 'required',
            'password' => 'required',
            'port' => 'required|integer'
        ];
    }
}
