<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CreateSendingServerRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return false;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $common = [
            'group_id' => 'required|integer',
            'name' => 'required',
            'from_name' => 'required',
            'from_email_part1' => 'required',
            'from_email_part2' => 'required',
            'reply_email' => 'required|email'
          ];

          switch($this->type) {
            case 'smtp':
              $custom = [
                'host' => 'required|string|max:255',
                'username' => 'required|string|max:255',
                'port' => 'required|integer|min:0',
              ];
            break;
            case 'amazon_ses_api':
              $custom = [
                'access_key' => 'required|string|max:255',
                'secret_key' => 'required|string|max:255',
              ];
            break;
            case 'mailgun_api':
              $custom = [
                'domain' => 'required|string|max:255',
                'api_key' => 'required|string|max:255',
              ];
            break;
            case 'sparkpost_api':
            case 'sendgrid_api':
              $custom = [
                'api_key' => 'required|string|max:255',
              ];
            break;
            default: 
              $custom = [];
            break;
          }
          return array_merge($common,$custom);
    }
}
