<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class DripRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        switch($this->method()) {
          case 'POST':
            return [
              'name' => 'required|string|max:255|unique:drips,name,NULL,id,group_id,'.$this->group_id,
              'email_subject' => 'required|string',
              'time' => 'required_if:send,==,After',
            ];
          break;
          case 'PUT':
            return [
              'name' => 'required|string|max:255',
              'email_subject' => 'required|string',
              'time' => 'required_if:send,==,After',
            ];
          break;
          default: 
            return [];
          break;
        }
    }
}
