<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class SplitTestRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        switch($this->method()) {
          case 'POST':
            return [
              'name' => 'required',
              'list_ids' => 'required',
              'broadcast_ids' => 'required',
              'sending_server_ids' => 'required',
              'send_remaining_after' => 'required_if:action,==,send_remaining',
              'limit' => 'required_if:sending_speed,==,limited',
            ];
          break;
          case 'PUT':
            return [
              'name' => 'required',
              'list_ids' => 'required',
              'broadcast_ids' => 'required',
              'sending_server_ids' => 'required',
              'send_remaining_after' => 'required_if:action,==,send_remaining',
              'limit' => 'required_if:sending_speed,==,limited',
            ];
          break;
          default: 
            return [];
          break;
      }
    }
}
