<?php

namespace App\Jobs;

use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Foundation\Queue\Queueable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class RunCampaign implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $id, $thread_no, $type;
    public $tries = 3;

    /**
     * Create a new job instance.
     */
    public function __construct($id, $thread_no, $type)
    {
        $this->id = $id;
        $this->thread_no = $thread_no;
        $this->type = $type;
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        try {
            if($this->type == 'split_test') {
                \Artisan::call('run:split-test-campaigns', [
                    'id'        => $this->id,
                    'thread_no' => $this->thread_no
                ]);
            } else {
                \Artisan::call('run:campaigns', [
                    'id'        => $this->id,
                    'thread_no' => $this->thread_no
                ]);
            }
        } catch(\Exception $e) {
            \Log::error('RunCampaign job failed: ' . $e->getMessage());
            throw $e; // Re-throw to mark job as failed
        }
    }
}
