<?php

namespace App\Listeners;

use Illuminate\Auth\Events\Login;
use Illuminate\Auth\Events\Logout;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;

class LogUserLoginActivity
{
    /**
     * Create the event listener.
     */
    public function __construct()
    {
        //
    }

    public function handle($event)
    {
        if ($event instanceof Login) {
            // Log the user login activity
            activity('signin')
                ->withProperties(['app_id' => $event->user->app_id])
                ->log("({$event->user->email}) " . __('app.log_signin')); // log sign-in
        }

        if ($event instanceof Logout) {
            activity('signout')
                ->withProperties(['app_id' => $event->user->app_id])
                ->log("({$event->user->email}) " . __('app.log_logout')); // log sign-out
        }
    }
}
