<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Bounce extends Model
{
    use HasFactory;

    protected $fillable = ['group_id', 'email', 'is_active', 'is_validate', 'method', 'host', 'username', 'password', 'port', 'encryption', 'validate_cert', 'delete_after_processing', 'app_id', 'user_id', 'pmta'];

    /**
    * Retrun query with active status
    */
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    /**
    * Retrun query assoicate with APP-ID
    */
    public function scopeApp($query)
    {
        return $query->where('bounces.app_id', \Auth::user()->app_id);
    }

    public function group()
    {
        return $this->belongsTo('App\Models\Group', 'group_id');
    }

    /**
    * Retrun bounce server groups
    */
    public static function groupBounceServers()
    {
        return Group::where('groups.type_id', config('custom.group_bounce_server'))
        ->where('groups.app_id', \Auth::user()->app_id)
        ->with('bounceServers')
        ->get();
    }

    /**
    * Retrun bounce server groups for client
    */
    public static function groupBounceServersClient($bounce_server_ids)
    {
        return Group::join('bounces', 'bounces.group_id', '=', 'groups.id')
          ->whereIn('bounces.id', $bounce_server_ids)
          ->with('bounceServers')
          ->distinct('groups.id')
          ->get();
    }

    /**
    * Retrun bounces either with json or array
    */
    public static function getBounces($return_type=null)
    {
        $bounces = Bounce::whereIsActive(true)->whereAppId(\Auth::user()->app_id);
        return $return_type == 'json' ? $bounces->pluck('email', 'id')->toJson() : $bounces->select('id', 'email')->get();
    }
}
