<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Broadcast extends Model
{
    use HasFactory;
    protected $fillable = ['name', 'group_id', 'email_subject', 'content_html', 'content_text', 'app_id', 'user_id', 'from_name', 'from_email', 'reply_email'];

    public function group()
    {
        return $this->belongsTo('App\Models\Group', 'group_id');
    }

    /**
    * Retrun broadcast groups
    */
    public static function groupBroadcasts()
    {
        return Group::where('groups.type_id', config('custom.group_campaigns'))
        ->where('groups.app_id', \Auth::user()->app_id)
        ->with('broadcasts')
        ->get();
    }

    /**
    * Retrun query assoicate with APP-ID
    */
    public function scopeApp($query)
    {
        return $query->where('app_id', \Auth::user()->app_id);
    }
}
