<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Drip extends Model
{
    use HasFactory;
    protected $fillable = ['is_active', 'name', 'group_id', 'content', 'email_subject', 'send', 'after_minutes', 'send_attributes', 'app_id', 'user_id'];

    public function group()
    {
        return $this->belongsTo('App\Models\Group', 'group_id');
    }

    public function scopeApp($query)
    {
        return $query->where('app_id', \Auth::user()->app_id);
    }
}
