<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DripScheduleStat extends Model
{
  use HasFactory;
  protected $fillable = ['drip_schedule_id', 'schedule_by', 'drip_schedule_name', 'drip_group_id', 'drip_group_name', 'app_id', 'user_id', 'broadcast'];

  /**
   * Retrun query assoicate with APP-ID
  */
  public function scopeApp($query)
  {
    return $query->where('app_id', \Auth::user()->app_id);
  }

  /**
   * Return query that helps to find unique data like lists, boradcasts, and sending_serers for schedule
   * @param int drip_schedule_stat_id
   * @param strin list, broadcast, sending_server
  */
  public static function statLogData($drip_schedule_stat_id, $value='list')
  {
    $query = DripScheduleStat::join('drip_schedule_stat_logs', 'drip_schedule_stats.id', '=', 'drip_schedule_stat_logs.drip_schedule_stat_id')
      ->where('drip_schedule_stats.id', $drip_schedule_stat_id)
      ->where('drip_schedule_stats.app_id', \Auth::user()->app_id)
      ->select("drip_schedule_stat_logs.{$value}")
      ->groupBy("drip_schedule_stat_logs.{$value}")
      ->select("drip_schedule_stat_logs.{$value}", \DB::raw('count(*) as total'));
    return $query;
  }

  /**
   * Return query that helps to find opens for a scheduled
   * @param int drip_schedule_stat_id
   * @param string all / unique
  */
  public static function statLogOpens($drip_schedule_stat_id, $filter='all')
  {
    $query = DripScheduleStat::join('drip_schedule_stat_logs', 'drip_schedule_stats.id', '=', 'drip_schedule_stat_logs.drip_schedule_stat_id')
      ->join('drip_schedule_stat_log_opens', 'drip_schedule_stat_logs.id', '=', 'drip_schedule_stat_log_opens.drip_schedule_stat_log_id')
      ->where('drip_schedule_stats.id', $drip_schedule_stat_id)
      ->where('drip_schedule_stats.app_id', \Auth::user()->app_id);

    if($filter == 'unique') {
      $query = $query->select('drip_schedule_stat_log_opens.drip_schedule_stat_log_id')
        ->groupBy('drip_schedule_stat_log_opens.drip_schedule_stat_log_id');
    } else {
      $query = $query->select('drip_schedule_stats.id as id', 'drip_schedule_stat_logs.drip_name as drip_name', 'drip_schedule_stat_logs.id as stat_log_id', 'drip_schedule_stat_logs.message_id', 'drip_schedule_stat_logs.email', 'drip_schedule_stat_logs.list', 'drip_schedule_stat_logs.broadcast', 'drip_schedule_stat_logs.sending_server', 'drip_schedule_stat_logs.status', 'drip_schedule_stat_log_opens.*');
    }
    return $query;
  }

  /**
   * Return query that helps to find clicks for a scheduled
   * @param int drip_schedule_stat_id
   * @param string all / unique
  */
  public static function statLogClicks($drip_schedule_stat_id, $filter='all')
  {
    $query = DripScheduleStat::join('drip_schedule_stat_logs', 'drip_schedule_stats.id', '=', 'drip_schedule_stat_logs.drip_schedule_stat_id')
      ->join('drip_schedule_stat_log_clicks', 'drip_schedule_stat_logs.id', '=', 'drip_schedule_stat_log_clicks.drip_schedule_stat_log_id')
      ->where('drip_schedule_stats.id', $drip_schedule_stat_id)
      ->where('drip_schedule_stats.app_id', \Auth::user()->app_id);

    if($filter == 'unique') {
      $query = $query->select('drip_schedule_stat_log_clicks.drip_schedule_stat_log_id')
        ->groupBy('drip_schedule_stat_log_clicks.drip_schedule_stat_log_id');
    } else {
      $query = $query->select('drip_schedule_stats.id as id', 'drip_schedule_stat_logs.drip_name as drip_name', 'drip_schedule_stat_logs.id as stat_log_id', 'drip_schedule_stat_logs.message_id', 'drip_schedule_stat_logs.email', 'drip_schedule_stat_logs.list', 'drip_schedule_stat_logs.broadcast', 'drip_schedule_stat_logs.sending_server', 'drip_schedule_stat_logs.status', 'drip_schedule_stat_log_clicks.*');
    }
    return $query;
  }

  /**
   * Return query that helps to find bounces for a scheduled
   * @param int drip_schedule_stat_id
  */
  public static function statLogBounces($scheduel_campaign_stat_id)
  {
    $query = DripScheduleStat::join('drip_schedule_stat_logs', 'drip_schedule_stats.id', '=', 'drip_schedule_stat_logs.drip_schedule_stat_id')
      ->join('global_bounces', 'drip_schedule_stat_logs.id', '=', 'global_bounces.schedule_campaign_stat_log_id')
      ->where('global_bounces.stat_id', $scheduel_campaign_stat_id)
      ->where('global_bounces.section', 'Drip')
      ->where('drip_schedule_stats.id', $scheduel_campaign_stat_id)
      ->where('drip_schedule_stats.app_id', \Auth::user()->app_id)
      ->select('drip_schedule_stats.id as id', 'drip_schedule_stat_logs.drip_name as drip_name', 'drip_schedule_stat_logs.id as stat_log_id', 'drip_schedule_stat_logs.message_id', 'drip_schedule_stat_logs.email', 'drip_schedule_stat_logs.list', 'drip_schedule_stat_logs.broadcast', 'drip_schedule_stat_logs.sending_server', 'drip_schedule_stat_logs.status', 'global_bounces.*');
    return $query;
  }

  /**
   * Return query that helps to find spam for a scheduled
   * @param int drip_schedule_stat_id
  */
  public static function statLogSpam($scheduel_campaign_stat_id)
  {
    $query = DripScheduleStat::join('drip_schedule_stat_logs', 'drip_schedule_stats.id', '=', 'drip_schedule_stat_logs.drip_schedule_stat_id')
      ->join('global_spams', 'drip_schedule_stat_logs.id', '=', 'global_spams.schedule_campaign_stat_log_id')
      ->where('drip_schedule_stats.id', $scheduel_campaign_stat_id)
      ->where('drip_schedule_stats.app_id', \Auth::user()->app_id)
      ->where('global_spams.section', 'Drip')
      ->select('drip_schedule_stats.id as id', 'drip_schedule_stat_logs.drip_name as drip_name', 'drip_schedule_stat_logs.id as stat_log_id', 'drip_schedule_stat_logs.message_id', 'drip_schedule_stat_logs.email', 'drip_schedule_stat_logs.list', 'drip_schedule_stat_logs.broadcast', 'drip_schedule_stat_logs.sending_server', 'drip_schedule_stat_logs.status', 'global_spams.*');;
    return $query;
  }

  /**
   * Return query that helps to find replies for a scheduled
   * @param int drip_schedule_stat_id
  */
  public static function statLogReplies($scheduel_campaign_stat_id)
  {
    $query = DripScheduleStat::join('drip_schedule_stat_logs', 'drip_schedule_stats.id', '=', 'drip_schedule_stat_logs.drip_schedule_stat_id')
      ->join('replies', 'drip_schedule_stat_logs.id', '=', 'replies.schedule_campaign_stat_log_id')
      ->where('drip_schedule_stats.id', $scheduel_campaign_stat_id)
      ->where('drip_schedule_stats.app_id', \Auth::user()->app_id)
      ->where('replies.section', 'Drip')
      ->select('drip_schedule_stats.id as id', 'drip_schedule_stat_logs.drip_name as drip_name', 'drip_schedule_stat_logs.id as stat_log_id', 'drip_schedule_stat_logs.message_id', 'drip_schedule_stat_logs.email', 'drip_schedule_stat_logs.list', 'drip_schedule_stat_logs.broadcast', 'drip_schedule_stat_logs.sending_server', 'drip_schedule_stat_logs.status', 'replies.*');;
    return $query;
  }

  /**
   * Return query that helps to find unique data like lists, boradcasts, and sending_serers for schedule
   * @param int drip_schedule_stat_id
   * @param strin list, broadcast, sending_server
  */
  public static function getUniqueCountries($drip_schedule_stat_id=null, $table='opens')
  {
    $table = $table == 'opens' ? 'drip_schedule_stat_log_opens' : 'drip_schedule_stat_log_clicks';

    $query = DripScheduleStat::join('drip_schedule_stat_logs', 'drip_schedule_stats.id', '=', 'drip_schedule_stat_logs.drip_schedule_stat_id')
      ->join($table, 'drip_schedule_stat_logs.id', '=', "$table.drip_schedule_stat_log_id");
      
    if(!empty($drip_schedule_stat_id)) {
      $query = $query->where('drip_schedule_stats.id', $drip_schedule_stat_id);
    }

    $query = $query->select(\DB::raw('count(country_code) as cnt, country_code'))
      ->groupBy("$table.country_code");

    return $query;
  }
}

