<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Fbl extends Model
{
    use HasFactory;

    protected $fillable = ['group_id', 'email', 'is_active', 'is_validate', 'method', 'host', 'username', 'password', 'port', 'encryption', 'validate_cert', 'delete_after_processing', 'app_id', 'user_id'];

    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    /**
    * Retrun query assoicate with APP-ID
    */
    public function scopeApp($query)
    {
        return $query->where('fbls.app_id', \Auth::user()->app_id);
    }

    public function group()
    {
        return $this->belongsTo('App\Models\Group', 'group_id');
    }

    /**
    * Retrun feedback loop server groups
    */
    public static function groupFblServers()
    {
        return Group::where('groups.type_id', config('custom.group_fbl_server'))
        ->where('groups.app_id', \Auth::user()->app_id)
        ->with('fblServers')
        ->get();
    }

    /**
    * Retrun feedback loop server groups for client
    */
    public static function groupFblServersClient($fbl_server_ids)
    {
        return Group::join('fbls', 'fbls.group_id', '=', 'groups.id')
          ->whereIn('fbls.id', $fbl_server_ids)
          ->with('fblServers')
          ->distinct('groups.id')
          ->get();
    }
}
