<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Group extends Model
{
    use HasFactory;
    protected $fillable = [
        'name', 'type_id', 'app_id', 'user_id'
    ];

    public function lists()
    {
        return $this->hasMany('App\Models\Lists');
    }

    public function broadcasts()
    {
        return $this->hasMany('App\Models\Broadcast');
    }

    public function sendingServers()
    {
        return $this->hasMany('App\Models\SendingServer')->whereStatus('Active');
    }

    public function bounceServers()
    {
        return $this->hasMany('App\Models\Bounce')->where('is_active', true);
    }

    public function replyServers()
    {
        return $this->hasMany('App\Models\ReplyServer')->where('is_active', true);
    }

    public function fblServers()
    {
        return $this->hasMany('App\Models\Fbl')->where('is_active', true);
    }

    /**
    * Retrun query assoicate with APP-ID
    */
    public function scopeApp($query)
    {
        return $query->where('groups.app_id', \Auth::user()->app_id);
    }

    public static function groups($type_id, $return_type=null)
    {
        $groups = Group::whereTypeId($type_id)
            ->whereAppId(\Auth::user()->app_id)
            ->orderBy('name')
            ->pluck('name', 'id');
        if($return_type == 'json') { 
          $groups->toJson();
        }
        return $groups;
    }
}
