<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Lists extends Model
{
    use HasFactory;
    
    protected $fillable = [
        'name', 'group_id', 'double_optin', 'welcome_email', 'description', 'notify_email', 'unsub_email', 'from_subject', 'from_name', 'from_email', 'reply_email', 'app_id', 'user_id', 'total_contacts'
    ];

    public function group()
    {
        return $this->belongsTo('App\Models\Group', 'group_id');
    }

    public function contacts()
    {
        return $this->hasMany('App\Models\Contact', 'list_id');
    }

    public function getCustomFieldId()
    {
        return $this->customFields->pluck('custom_field_id');
    }

    public function customFields()
    {
      return $this->belongsToMany('App\Models\CustomField', 'list_custom_fields', 'list_id', 'custom_field_id')->select('custom_field_id', 'custom_fields.name', 'custom_fields.type', 'custom_fields.values', 'custom_fields.tag', 'custom_fields.is_required');
    }

    /**
    * Retrun list groups
    */
    public static function groupLists()
    {
        return Group::where('groups.type_id', config('custom.group_lists'))
        ->where('groups.app_id', \Auth::user()->app_id)
        ->with('lists')
        ->get();
    }
    /**
    * Retrun list groups
    */
    public static function groupListsClient($list_ids)
    {
        return Group::join('lists', 'lists.group_id', '=', 'groups.id')
          ->select('groups.*')
          ->whereIn('lists.id', $list_ids)
          ->with('lists')
          ->distinct('groups.id')
          ->get();
    }

    /**
    * Retrun query assoicate with APP-ID
    */
    public function scopeApp($query)
    {
        return $query->where('lists.app_id', \Auth::user()->app_id);
    }
}
