<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Replies extends Model
{
    use HasFactory;
    const UPDATED_AT = null; // Disable updated_at
    
    protected $fillable = ['stat_id', 'schedule_campaign_stat_log_id', 'section', 'email', 'detail', 'created_at', 'app_id'];

    /**
    * Retrun query assoicate with APP-ID
    */
    public function scopeApp($query)
    {
        return $query->where('replies.app_id', \Auth::user()->app_id);
    }
}
