<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ReplyServer extends Model
{
    use HasFactory;

    protected $fillable = ['group_id', 'email', 'is_active', 'is_validate', 'method', 'host', 'username', 'password', 'port', 'encryption', 'validate_cert', 'delete_after_processing', 'app_id', 'user_id'];

    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    /**
    * Retrun query assoicate with APP-ID
    */
    public function scopeApp($query)
    {
        return $query->where('reply_servers.app_id', \Auth::user()->app_id);
    }

    public function group()
    {
        return $this->belongsTo('App\Models\Group', 'group_id');
    }

    /**
    * Retrun reply server groups
    */
    public static function groupReplyServers()
    {
        return Group::where('groups.type_id', config('custom.group_reply_server'))
        ->where('groups.app_id', \Auth::user()->app_id)
        ->with('replyServers')
        ->get();
    }

    /**
    * Retrun reply server groups for client
    */
    public static function groupReplyServersClient($reply_server_ids)
    {
        return Group::join('reply_servers', 'reply_servers.group_id', '=', 'groups.id')
          ->whereIn('reply_servers.id', $reply_server_ids)
          ->with('replyServers')
          ->distinct('groups.id')
          ->get();
    }
}
