<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ScheduleCampaignSentLog extends Model
{
    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'schedule_campaign_sent_logs';

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'schedule_campaign_id',
        'schedule_campaign_stat_log_id',
        'email',
    ];

    /**
     * Get the schedule campaign that owns the sent log.
     */
    public function scheduleCampaign(): BelongsTo
    {
        return $this->belongsTo(ScheduleCampaign::class);
    }

    /**
     * Get the schedule campaign stat log that owns the sent log.
     */
    public function scheduleCampaignStatLog(): BelongsTo
    {
        return $this->belongsTo(ScheduleCampaignStatLog::class);
    }
}
