<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SendingDomain extends Model
{
    use HasFactory;

    protected $fillable = ['domain', 'protocol', 'is_active', 'is_verified', 
        'auto_verification', 'public_key', 'private_key', 'host_dkim', 'value_dkim', 'host_spf', 'value_spf', 'host_dmarc', 
        'value_dmarc', 'is_verified_key', 'is_verified_spf', 'is_verified_dmarc', 'app_id', 'user_id', 'group_id', 'pmta'];

    /**
    * Retrun query assoicate with APP-ID
    */
    public function scopeApp($query)
    {
        return $query->where('sending_domains.app_id', \Auth::user()->app_id);
    }

    public static function getSendingDomains($return_type=null)
    {
        $domains = SendingDomain::whereIsActive(true)->whereAppId(\Auth::user()->app_id);
        return $return_type == 'json' ? $domains->pluck('domain', 'id')->toJson() : $domains->select('id', 'domain', 'protocol')->get();
    }
}
