<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SplitTest extends Model
{
    use HasFactory;
    
    protected $fillable = ['name', 'send','send_datetime', 'list_ids', 'broadcast_ids', 'winning_criteria','decision_percentage', 'action',
    'action_data','sending_speed', 'sending_datetime', 'scheduled_detail', 'sending_server_ids', 'attributes', 'app_id', 'user_id', 'is_active'];

    /**
    * Retrun query assoicate with APP-ID
    */
    public function scopeApp($query)
    {
        return $query->where('app_id', \Auth::user()->app_id);
    }

    public function splitTestStat()
    {
        return $this->hasOne('App\Models\SplitTestStat', 'split_test_id');
    }
}
