<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class WarmupPlan extends Model
{
    use HasFactory;
    protected $fillable = ['name', 'growth_factor', 'total_emails', 'days', 'schedule', 'is_active', 'user_id', 'app_id'];

    /**
    * Retrun query assoicate with APP-ID
    */
    public function scopeApp($query)
    {
        return $query->where('app_id', \Auth::user()->app_id);
    }

    /**
    * Retrun bounces either with json or array
    */
    public static function getWarmupPlans($return_type=null)
    {
        $bounces = WarmupPlan::whereIsActive(true)->whereAppId(\Auth::user()->app_id);
        return $return_type == 'json' ? $bounces->pluck('name', 'id')->toJson() : $bounces->select('id', 'name')->get();
    }
}
