<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Webform extends Model
{
    use HasFactory;
    protected $fillable = ['name', 'duplicates', 'list_id', 'custom_field_ids', 'app_id', 'user_id', 'attributes', 'is_recaptcha', 'recaptcha_site_key'];

    public function list()
    {
        return $this->belongsTo('App\Models\Lists', 'list_id');
    }

    /**
    * Retrun query assoicate with APP-ID
    */
    public function scopeApp($query)
    {
        return $query->where('app_id', \Auth::user()->app_id);
    }
}
