<?php
namespace App\Services;

use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;

class ChatGPTService
{
    public static function improveText(string $prompt): ?string
    {
        $user = Auth::user();

        if (!$user || !$user->chatgpt_key) {
            Log::error('ChatGPT: No user or API key.');
            return null;
        }

        $endpoint = 'https://api.openai.com/v1/chat/completions';

        try {
            $response = Http::withHeaders([
                'Authorization' => 'Bearer ' . $user->chatgpt_key,
                'Content-Type' => 'application/json',
            ])->post($endpoint, [
                'model' => $user->chatgpt_model,
                'messages' => [
                    ['role' => 'system', 'content' => 'You are a helpful AI assistant.'],
                    ['role' => 'user', 'content' => $prompt],
                ],
                'temperature' => 0.7,
            ]);

            if (!$response->successful()) {
                return $response->body();
            }

            return $response->json()['choices'][0]['message']['content'] ?? null;
        } catch (\Exception $e) {
            return $e->getMessage();
        }
    }
}
