<?php

namespace App\Services;

use GuzzleHttp\Client;
use Illuminate\Support\Facades\Crypt;

class ElasticEmailService
{
    protected static $apiUrl = 'https://api.elasticemail.com/v2/email/send';

    public static function send($api_key, $from_email, $from_name, $to_email, $reply_email, $subject, $content, $message_id=null, $attachments_path=null, $attachments=null)
    {

        $api_key = Crypt::decrypt($api_key);

        $multipart = [
            ['name' => 'apikey', 'contents' => $api_key],
            ['name' => 'from', 'contents' => $from_email],
            ['name' => 'fromName', 'contents' => $from_name],
            ['name' => 'to', 'contents' => $to_email],
            ['name' => 'replyTo', 'contents' => $reply_email],
            ['name' => 'subject', 'contents' => $subject],
            ['name' => 'bodyHtml', 'contents' => $content],
            ['name' => 'bodyText', 'contents' => $content],
            ['name' => 'isTransactional', 'contents' => 'true'],
            [ 'name' => 'postback', 'contents' => $message_id ],
        ];

        if (!empty($attachments)) {
            foreach ($attachments as $filename) {
              $attached_file = $attachments_path . DIRECTORY_SEPARATOR . $filename;
                if (file_exists($attached_file)) {
                  // Attach to Elastic Email message
                  $multipart[] = [
                      'name'     => 'file',
                      'contents' => fopen($attached_file, 'r'),
                      'filename' => $filename,
                  ];
                }
            }
        }

        try {

            $client = new Client();
            $response = $client->request('POST', self::$apiUrl, [
                'multipart' => $multipart,
            ]);

            $statusCode = $response->getStatusCode();
            return ($statusCode >= 200 && $statusCode < 300) ? true : false;
        } catch (\Exception $e) {
            // Optionally log the error here
            return false;
        }
    }
}
