<?php

namespace App\Services;

use SendGrid;
use SendGrid\Mail\Mail;
use Illuminate\Support\Facades\Crypt;

class SendGridService
{
    public static function send($api_key, $from_email, $from_name, $to_email, $reply_email, $subject, $content, $content_type = 'html', $message_id = null, $attachments_path = null, $attachments = null)
    {
        $decrypted_api_key = Crypt::decrypt($api_key);

        $message = new Mail();
        $message->setFrom($from_email, $from_name);

        if (!empty($reply_email)) {
            $message->setReplyTo($reply_email);
        }

        $message->addTo($to_email);
        $message->setSubject($subject);

        if ($content_type == 'html') {
            $message->addContent("text/html", $content);
            $message->addContent("text/plain", $content);
        } else {
            $message->addContent("text/plain", $content);
        }

        if (!empty($message_id)) {
            $message->addCustomArg('rz_message_id', $message_id);
            $message->addHeader('RZ-Type-ID', $message_id);
        }

        if (!empty($attachments)) {
            foreach ($attachments as $filename) {
                $attached_file = $attachments_path . DIRECTORY_SEPARATOR . $filename;
                if (file_exists($attached_file)) {
                    $file_content = base64_encode(file_get_contents($attached_file));
                    $file_mime = mime_content_type($attached_file);

                    $message->addAttachment(
                        $file_content,
                        $file_mime,
                        $filename,
                        "attachment"
                    );
                }
            }
        }

        $sendgrid = new SendGrid($decrypted_api_key);

        try {
            $response = $sendgrid->send($message);

            // Check if response code is 2xx
            if (floor($response->statusCode() / 100) == 2) {
                return true;
            } else {
                return false;
            }
        } catch (\Exception $e) {
            \Log::error('SendGridService Error: ' . $e->getMessage());
            return false;
        }
    }
}
