<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('settings', function (Blueprint $table) {
            $table->id();
            $table->string('app_name')->nullable();
            $table->string('app_url')->nullable();
            $table->enum('tracking', ['enabled', 'disabled'])->default('enabled');
            $table->string('from_name')->nullable();
            $table->string('from_email')->nullable();
            $table->enum('sending_type', ['php_mail', 'smtp', 'amazon_ses_api', 'mailgun_api', 'sparkpost_api', 'sendgrid_api'])->default('php_mail');
            $table->json('sending_attributes')->nullable();
            $table->json('attributes')->nullable();
            $table->string('current_version')->default('1.0.0');
            $table->string('server_ip')->nullable();
            $table->string('license_key')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('settings');
    }
};
