<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('schedule_campaigns', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('list_ids')->nullable();
            $table->string('sending_server_ids')->nullable();
            $table->text('email_subject')->nullable();
            $table->longText('content')->nullable();            
            $table->string('from_detail')->nullable();
            $table->json('from_detail_custom')->nullable();
            $table->enum('send', ['now', 'later'])->default('now');
            $table->timestamp('send_datetime')->useCurrent();
            $table->json('sending_speed')->nullable();
            $table->unsignedTinyInteger('threads')->default(5);
            $table->unsignedInteger('thread_no')->default(1);
            $table->unsignedInteger('total_threads')->nullable();
            $table->unsignedInteger('total')->nullable();
            $table->unsignedInteger('scheduled')->default(0);
            $table->unsignedInteger('sent')->default(0);
            $table->json('scheduled_detail')->nullable();
            $table->enum('status', ['Preparing', 'Scheduled', 'Running', 'RunningLimit', 'Paused', 'System Paused', 'Completed', 'Draft', 'Resume'])->default('Preparing');
            $table->unsignedBigInteger('app_id')->nullable();
            $table->unsignedBigInteger('user_id')->nullable();
            $table->timestamps();

            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('schedule_campaigns');
    }
};
