<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('schedule_campaign_stat_logs', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('schedule_campaign_stat_id')->nullable();
            $table->string('message_id')->nullable();
            $table->string('email')->nullable();
            $table->string('list')->nullable();
            $table->string('sending_server')->nullable();
            $table->enum('status', ['Sent', 'Failed', 'Unsubscribed', 'Opened', 'Clicked', 'Bounced', 'Spammed'])->default('Sent');
            $table->timestamps();

            $table->foreign('schedule_campaign_stat_id', 'scsl_id_scs_id')->references('id')->on('schedule_campaign_stats')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('schedule_campaign_stat_logs');
    }
};
