<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('trigger_schedule_stat_logs', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('trigger_schedule_stat_id')->nullable();
            $table->string('message_id')->nullable();
            $table->string('email')->nullable();
            $table->string('list')->nullable();
            $table->string('sending_server')->nullable();
            $table->enum('status', ['Sent', 'Failed', 'Unsubscribed', 'Opened', 'Clicked', 'Bounced', 'Spammed'])->default('Sent');
            $table->timestamps();

            $table->foreign('trigger_schedule_stat_id', 'tssl_id_tss_id')->references('id')->on('trigger_schedule_stats')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('trigger_schedule_stat_logs');
    }
};
