<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('drip_schedules', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->unsignedBigInteger('drip_group_id')->nullable();
            $table->unsignedBigInteger('trigger_id')->nullable();
            $table->string('list_ids')->nullable();
            $table->string('sending_server_ids')->nullable();
            $table->enum('send_to_existing', ['Yes', 'No'])->default('Yes');
            $table->enum('status', ['Running', 'Paused'])->default('Running');
            $table->boolean('in_progress')->default(false);
            $table->unsignedBigInteger('app_id')->nullable();
            $table->unsignedBigInteger('user_id')->nullable();
            $table->timestamps();

            $table->foreign('drip_group_id')->references('id')->on('groups');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('drip_schedules');
    }
};
