<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('drip_schedule_stats', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('drip_schedule_id')->nullable();
            $table->string('schedule_by')->nullable();
            $table->string('drip_schedule_name')->nullable();
            $table->string('drip_group_name')->nullable();
            $table->unsignedBigInteger('app_id')->nullable();
            $table->unsignedBigInteger('user_id')->nullable();
            $table->timestamps();
            });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('drip_schedule_stats');
    }
};
