<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('drip_schedule_stat_logs', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('drip_schedule_stat_id')->nullable();
            $table->unsignedBigInteger('drip_id')->nullable();
            $table->string('drip_name')->nullable();
            $table->string('message_id')->nullable();
            $table->string('email')->nullable();
            $table->string('list')->nullable();
            $table->string('broadcast')->nullable();
            $table->string('sending_server')->nullable();
            $table->enum('status', ['Sent', 'Failed', 'Unsubscribed', 'Opened', 'Clicked', 'Bounced', 'Spammed'])->default('Sent');
            $table->timestamps();

            $table->foreign('drip_schedule_stat_id', 'dssl_id_dss_id')->references('id')->on('drip_schedule_stats')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('drip_schedule_stat_logs');
    }
};
