<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('drip_schedule_stat_log_opens', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('drip_schedule_stat_log_id')->nullable();
            $table->string('ip')->nullable();
            $table->string('country')->nullable();
            $table->char('country_code', 2)->nullable();
            $table->string('city')->nullable();
            $table->string('zipcode')->nullable();
            $table->string('user_agent')->nullable();
            $table->timestamp('created_at')->useCurrent();

            $table->foreign('drip_schedule_stat_log_id', 'dsslo_id_dssl_id')->references('id')->on('drip_schedule_stat_logs')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('drip_schedule_stat_log_opens');
    }
};
