<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('split_tests', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->boolean('is_active')->default(true);
            $table->enum('send', ['now', 'later'])->default('now');
            $table->timestamp('send_datetime')->useCurrent();
            $table->string('list_ids')->nullable();
            $table->text('broadcast_ids')->nullable();
            $table->string('winning_criteria')->nullable();
            $table->unsignedTinyInteger('decision_percentage')->nullable();
            $table->unsignedInteger('percentage_sent')->nullable();
            $table->unsignedInteger('winning_campaign_id')->nullable();
            $table->string('winning_campaign_name')->nullable();
            $table->string('action')->nullable();
            $table->json('action_data')->nullable();
            $table->text('sending_server_ids')->nullable();
            $table->json('sending_speed')->nullable();
            $table->timestamp('decision_datetime')->nullable();
            $table->timestamp('sending_datetime')->nullable();
            $table->json('attributes')->nullable();
            $table->unsignedTinyInteger('threads')->default(5);
            $table->unsignedInteger('thread_no')->default(0);
            $table->unsignedInteger('total_threads')->nullable();
            $table->unsignedInteger('total')->default(0);
            $table->unsignedInteger('scheduled')->default(0);
            $table->unsignedInteger('sent')->default(0);
            $table->json('scheduled_detail')->nullable();
            $table->enum('status', ['Not Started', 'Preparing', 'Scheduled', 'Running', 'RunningLimit', 'Paused', 'System Paused', 'Decision Paused', 'Completed', 'Resume'])->default('Not Started');
            $table->unsignedBigInteger('app_id')->nullable();
            $table->unsignedBigInteger('user_id')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('split_tests');
    }
};
