<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('split_test_stats', function (Blueprint $table) {
            $table->id();
            $table->unsignedInteger('split_test_id')->unique();
            $table->string('split_test_name')->nullable();
            $table->string('winning_criteria')->nullable();
            $table->unsignedTinyInteger('decision_percentage')->nullable();
            $table->string('action')->nullable();
            $table->json('action_data')->nullable();
            $table->string('schedule_by')->nullable();
            $table->unsignedTinyInteger('threads')->default(5);
            $table->unsignedInteger('total')->nullable();
            $table->unsignedInteger('scheduled')->nullable();
            $table->unsignedInteger('sent')->nullable();
            $table->json('opens_clicks')->nullable();
            $table->json('scheduled_detail')->nullable();
            $table->json('sending_speed')->nullable();
            $table->timestamp('start_datetime')->nullable();
            $table->timestamp('end_datetime')->nullable();
            $table->unsignedBigInteger('app_id')->nullable();
            $table->unsignedBigInteger('user_id')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('split_test_stats');
    }
};
