<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('split_test_stat_logs', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('split_test_stat_id')->nullable();
            $table->string('message_id')->nullable();
            $table->string('email')->nullable();
            $table->string('list')->nullable();
            $table->string('broadcast')->nullable();
            $table->string('sending_server')->nullable();
            $table->enum('status', ['Sent', 'Failed', 'Unsubscribed', 'Opened', 'Clicked', 'Bounced', 'Spammed'])->default('Sent');
            $table->timestamps();

            $table->foreign('split_test_stat_id', 'stsl_id_sts_id')->references('id')->on('split_test_stats')->onDelete('cascade');
            });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('split_test_stat_logs');
    }
};
