<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('split_test_stat_log_clicks', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('split_test_stat_log_id')->nullable();
            $table->text('link')->nullable();
            $table->string('ip')->nullable();
            $table->string('country')->nullable();
            $table->char('country_code', 2)->nullable();
            $table->string('city')->nullable();
            $table->string('zipcode')->nullable();
            $table->string('user_agent')->nullable();
            $table->boolean('unsub_confirmed')->default(false);
            $table->timestamp('created_at')->useCurrent();

            $table->foreign('split_test_stat_log_id', 'stslc_id_stsl_id')->references('id')->on('split_test_stat_logs')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('split_test_stat_log_clicks');
    }
};
