<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('webforms', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->enum('duplicates', ['Skip', 'Overwrite'])->default('Skip');
            $table->unsignedBigInteger('list_id')->nullable();
            $table->string('custom_field_ids')->nullable();
            $table->longText('attributes')->nullable();
            $table->unsignedBigInteger('app_id')->nullable();
            $table->unsignedBigInteger('user_id')->nullable();
            $table->timestamps();

            $table->foreign('list_id')->references('id')->on('lists')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('webforms');
    }
};
