<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('blacklisteds', function (Blueprint $table) {
            $table->id();
            $table->string('name', 255)->nullable();
            $table->enum('ip_domain', ['ip', 'domain'])->default('ip');
            $table->longText('detail')->nullable();
            $table->unsignedInteger('counts');
            $table->unsignedBigInteger('app_id')->nullable();
            $table->unsignedBigInteger('user_id')->nullable();
            $table->timestamp('created_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('blacklisteds');
    }
};
