<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('warmup_plans', function (Blueprint $table) {
            $table->id();
            $table->string('name'); // Name of the warm-up plan
            $table->boolean('is_active')->default(true);
             $table->integer('total_emails'); // Total emails for warm-up
            $table->integer('days'); // Duration in days
            $table->decimal('growth_factor', 5, 2)->default(1.5); // Growth factor
            $table->json('schedule')->nullable(); // Stores daily schedule as JSON
            $table->unsignedBigInteger('app_id')->nullable();
            $table->unsignedBigInteger('user_id')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('warmup_plans');
    }
};
