<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('schedule_campaigns', function (Blueprint $table) {
            $table->boolean('open_tracking')->default(true)->after('send');
            $table->boolean('click_tracking')->default(true)->after('open_tracking');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('schedule_campaigns', function (Blueprint $table) {
            $table->dropColumn(['open_tracking', 'click_tracking']);
        });
    }
};
