<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('schedule_campaigns', function (Blueprint $table) {
            $table->longText('content_text')->nullable()->after('content');
            $table->string('sending_content')->default('html')->nullable()->after('content_text');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('schedule_campaigns', function (Blueprint $table) {
            $table->dropColumn('content_text');
            $table->dropColumn('sending_content');
        });
    }
};
