<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('webforms', function (Blueprint $table) {
            $table->boolean('is_recaptcha')->default(false)->after('attributes');
            $table->string('recaptcha_site_key')->after('is_recaptcha')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('webforms', function (Blueprint $table) {
            $table->dropColumn(['is_recaptcha', 'recaptcha_site_key']);
        });
    }
};
