<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->string('chatgpt_key')->nullable()->after('api_enabled');
            $table->string('chatgpt_model')->default('gpt-3.5-turbo')->after('chatgpt_key');
            $table->boolean('chatgpt_enabled')->default(false)->after('chatgpt_model');            
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn('chatgpt_key');            
            $table->dropColumn('chatgpt_model');
            $table->dropColumn('chatgpt_enabled');
        });
    }
};
