<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('schedule_campaign_sent_logs', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('schedule_campaign_id');
            $table->unsignedBigInteger('schedule_campaign_stat_log_id');
            $table->string('email');
            $table->timestamps();
            
            // Foreign key constraints with shorter names
            $table->foreign('schedule_campaign_id', 'sc_sent_logs_campaign_fk')->references('id')->on('schedule_campaigns')->onDelete('cascade');
            $table->foreign('schedule_campaign_stat_log_id', 'sc_sent_logs_stat_fk')->references('id')->on('schedule_campaign_stat_logs')->onDelete('cascade');
            
            // Indexes for better performance
            $table->index('schedule_campaign_id', 'sc_sent_logs_campaign_idx');
            $table->index('schedule_campaign_stat_log_id', 'sc_sent_logs_stat_idx');
            $table->index('email', 'sc_sent_logs_email_idx');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('schedule_campaign_sent_logs');
    }
};
